<?php
if (!defined('ABSPATH')) exit;

jw3_log("=== REPROCESS TAXONOMIES START ===");

// Buscar todos os imóveis
$posts = get_posts([
    'post_type'      => 'spaciaz_project',
    'posts_per_page' => -1,
    'fields'         => 'ids'
]);

$total   = count($posts);
$updated = 0;

foreach ($posts as $post_id){

    $raw = get_post_meta($post_id, '_jetimob_raw', true);

    if (!$raw || !is_array($raw)){
        jw3_log("RAW NOT FOUND for {$post_id}");
        continue;
    }

    $external = $raw['codigo'] ?? $post_id;

    /* =====================================================
       STATUS
       ===================================================== */
    $status = null;

    if (!empty($raw['status_imovel'])) {
        $status = trim($raw['status_imovel']);
    } elseif (!empty($raw['status'])) {
        $status = trim($raw['status']);
    }

    if ($status) {
        wp_set_post_terms($post_id, [$status], 'project_status', false);
        jw3_log("STATUS UPDATED -> {$external} => {$status}");
    } else {
        wp_set_post_terms($post_id, [], 'project_status', false);
        jw3_log("NO STATUS -> {$external}");
    }


    /* =====================================================
       TIPO DO IMÓVEL
       ===================================================== */
    $tipo = null;

    if (!empty($raw['tipo_imovel'])) {
        $tipo = trim($raw['tipo_imovel']);
    } elseif (!empty($raw['tipo'])) {
        $tipo = trim($raw['tipo']);
    } elseif (!empty($raw['categoria'])) {
        $tipo = trim($raw['categoria']);
    }

    if ($tipo) {
        wp_set_post_terms($post_id, [$tipo], 'project_type', false);
        jw3_log("TIPO UPDATED -> {$external} => {$tipo}");
    } else {
        wp_set_post_terms($post_id, [], 'project_type', false);
        jw3_log("NO TIPO -> {$external}");
    }


    /* =====================================================
   LOCALIZAÇÃO — cidade / bairro (corrigido)
   ===================================================== */

$cidade = null;
$bairro = null;

/* Jetimob envia:
   endereco_cidade → nome da cidade
   endereco_bairro → nome do bairro
*/

if (!empty($raw['endereco_cidade'])) {
    $cidade = trim($raw['endereco_cidade']);
}

if (!empty($raw['endereco_bairro'])) {
    $bairro = trim($raw['endereco_bairro']);
}

/* ======== DEFINE TAXONOMIA project_city ======== */
if ($cidade) {
    wp_set_post_terms($post_id, [$cidade], 'project_city', false);
    jw3_log("CIDADE UPDATED -> {$external} => {$cidade}");
} else {
    wp_set_post_terms($post_id, [], 'project_city', false);
    jw3_log("NO CIDADE -> {$external}");
}

/* ======== DEFINE TAXONOMIA project_neighborhood ======== */
if ($bairro) {
    wp_set_post_terms($post_id, [$bairro], 'project_neighborhood', false);
    jw3_log("BAIRRO UPDATED -> {$external} => {$bairro}");
} else {
    wp_set_post_terms($post_id, [], 'project_neighborhood', false);
    jw3_log("NO BAIRRO -> {$external}");
}



    $updated++;
}

jw3_log("=== REPROCESS TAXONOMIES COMPLETE ({$updated} / {$total}) ===");

wp_redirect(admin_url('options-general.php?page=jw3-imp'));
exit;
