<?php
if (!defined('ABSPATH')) exit;

jw3_log("=== REPROCESS TAGS (UNIDADES BADEN) START ===");

// Buscar todos os imóveis
$posts = get_posts([
    'post_type'      => 'spaciaz_project',
    'posts_per_page' => -1,
    'fields'         => 'ids'
]);

$total   = count($posts);
$updated = 0;

foreach ($posts as $post_id){

    $raw = get_post_meta($post_id, '_jetimob_raw', true);

    if (!$raw || !is_array($raw)){
        jw3_log("RAW NOT FOUND for post {$post_id}");
        continue;
    }

    $external = $raw['codigo'] ?? $post_id;

    /* -------------------------------------------------------
       Limpa termos anteriores
    ------------------------------------------------------- */
    wp_set_post_terms($post_id, [], 'unidades_baden', false);

    /* -------------------------------------------------------
       Preparação das tags
    ------------------------------------------------------- */
    if (empty($raw['tags'])){
        jw3_log("NO TAGS for {$external}");
        continue;
    }

    $tags = is_array($raw['tags']) ? $raw['tags'] : explode(',', $raw['tags']);
    $tags = array_map('trim', $tags);

    $term_ids = [];

    foreach ($tags as $tag){

        if ($tag === '') continue;

        // Verifica se já existe
        $exists = term_exists($tag, 'unidades_baden');

        if (!$exists){
            $insert = wp_insert_term($tag, 'unidades_baden');

            if (is_wp_error($insert)){
                jw3_log("TERM ERROR '{$tag}' -> " . $insert->get_error_message());
                continue;
            }

            $term_id = $insert['term_id'];
            jw3_log("TERM CREATED unidades_baden => {$tag}");
        } else {
            $term_id = is_array($exists) ? $exists['term_id'] : $exists;
        }

        $term_ids[] = intval($term_id);
    }

    if (empty($term_ids)){
        jw3_log("NO VALID TAGS for {$external}");
        continue;
    }

    /* -------------------------------------------------------
       Associa termos ao imóvel
    ------------------------------------------------------- */
    $set = wp_set_post_terms($post_id, $term_ids, 'unidades_baden', false);

    if (is_wp_error($set)){
        jw3_log("SET_TERM ERROR TAGS for {$external} -> " . $set->get_error_message());
    } else {
        $updated++;
        jw3_log("TAGS UPDATED {$external} -> " . implode(",", $term_ids));
    }
}

jw3_log("=== REPROCESS TAGS COMPLETE ({$updated} / {$total}) ===");

wp_redirect(admin_url('options-general.php?page=jw3-imp'));
exit;
