<?php
if (!defined('ABSPATH')) exit;

jw3_log("=== REPROCESS COMODIDADES START ===");

// Buscar todos os imóveis
$posts = get_posts([
    'post_type'      => 'spaciaz_project',
    'posts_per_page' => -1,
    'fields'         => 'ids'
]);

$total   = count($posts);
$updated = 0;

foreach ($posts as $post_id){

    $raw = get_post_meta($post_id, '_jetimob_raw', true);

    if (!$raw || !is_array($raw)){
        jw3_log("RAW NOT FOUND for {$post_id}");
        continue;
    }

    $external = $raw['codigo'] ?? $post_id;

    /** -----------------------------------------
     * Coleta comodidades
     * ----------------------------------------- */
    $imovel = $raw['imovel_comodidades'] ?? [];
    $condo  = $raw['condominio_comodidades'] ?? [];

    // Junta tudo e remove duplicados
    $all = array_unique(array_filter(array_merge((array)$imovel, (array)$condo)));

    /** -----------------------------------------
     * Formata individualmente:
     *
     * CADA ITEM = 1 FEATURE
     * ----------------------------------------- */
    $features = [];

    foreach ($all as $item) {

        // Garantir que não vem lista separada por vírgula
        $splitted = array_map('trim', explode(',', $item));

        foreach ($splitted as $single) {
            if (!$single) continue;

            $features[] = [
                'icon'  => 'fas fa-check-circle',
                'title' => $single
            ];
        }
    }

    if (!empty($features)) {
        update_post_meta($post_id, '_spaciaz_project_features', $features);
        jw3_log("FEATURES UPDATED -> {$external}");
    } else {
        delete_post_meta($post_id, '_spaciaz_project_features');
        jw3_log("NO FEATURES -> {$external}");
    }

    $updated++;
}

jw3_log("=== REPROCESS COMODIDADES COMPLETE ({$updated} / {$total}) ===");

wp_redirect(admin_url('options-general.php?page=jw3-imp'));
exit;
