<div class="service-inner">
    <div class="service-content">
        <?php
        $icon_url = get_post_meta(get_the_ID(), 'services_icon_class', true);
        if (!empty($icon_url)) {
            echo '<div class="icon-wrap"><img class="service-icon" src="' . esc_url($icon_url) . '" alt="service icon"></div>';
        }
        ?>
        <h5 class="service-title">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h5>
        <div class="description">
            <?php echo get_the_excerpt(); ?>
        </div>
    </div>

    <div class="service-button-wrap"
        <?php
        if (has_post_thumbnail()) {
            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'large');
            echo ' style="background-image: url(' . esc_url($image_url) . ');"';
        }
        ?>>
        <a class="service-button" href="<?php the_permalink(); ?>">
            <span class="btn-icon-wrap">
                <span class="btn-icon"><i class="spaciaz-icon-arrow-long-right"></i></span>
                <span class="btn-icon-hover"><i class="spaciaz-icon-arrow-long-right"></i></span>
            </span>
        </a>
    </div>
</div>
