<?php
$project_id = get_the_ID();
$raw = get_post_meta($project_id, '_jetimob_raw', true);

$quartos = '';
$vagas   = '';

if (is_array($raw)) {
    $quartos = !empty($raw['dormitorios']) ? intval($raw['dormitorios']) : '';
    $vagas   = !empty($raw['garagens'])    ? intval($raw['garagens'])    : '';
}
?>

<div class="project-item project-style-2">
    <div class="project-post-thumbnail">

        <?php 
        $project_id = get_the_ID();

        // Pega a thumb principal importada do Jetimob
        $thumb = get_post_meta($project_id, 'jetimob_thumb', true);

        // Se a thumb não existir, usa a primeira imagem da galeria
        if (empty($thumb)) {
            $imgs = get_post_meta($project_id, 'jetimob_images', true);
            if (!empty($imgs) && is_array($imgs)) {
                $thumb = $imgs[0];
            }
        }

        // Exibe a imagem se existir
        if (!empty($thumb)) {
            echo '<img src="' . esc_url($thumb) . '" alt="' . esc_attr(get_the_title($project_id)) . '">';
        }
        ?>
        
    </div><!-- .post-thumbnail -->

    <div class="project-content">

 
        <div class="project-status projectstatus">
           <span> <?php
            $raw = get_post_meta($project_id, '_jetimob_raw', true);

            if (is_array($raw) && !empty($raw['endereco_cidade'])) {
                echo esc_html($raw['endereco_cidade']);
            } else {
                echo '—';
            }
            ?></span>
        </div>
  

    <?php
    // LOCALIZAÇÃO
    $location = get_the_term_list(get_the_ID(), 'project_location', '', ' ', '');
    if (!empty(trim(strip_tags($location)))) :
    ?>
        <div class="project-location">
            <i class="spaciaz-icon-marker"></i>
            <?php echo $location; ?>
        </div>
    <?php endif; ?>

    <?php if (get_the_title()) : ?>
        <h4 class="project-title delta" style="font-size:24px;">
            <a href="<?php the_permalink(); ?>">
                <?php the_title(); ?>
            </a>
        </h4>
    <?php endif; ?>

<div class="key-box">
    <div class="key-info">

        <span class="key-value">
			 <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-format-square"></i>
            <?php 
              $area_terms = wp_get_post_terms($project_id, 'project_area');
              echo !empty($area_terms) ? esc_html($area_terms[0]->name) : '—';
            ?>
        </span>
		<?php if ($quartos !== '') : ?>
        <span class="key-value" style="margin-left:5px">
			 <i aria-hidden="true" class="fas fa-bed"></i>
             <?php echo esc_html($quartos); ?> quartos
        </span>
	   <?php endif; ?>
		<?php if ($vagas !== '') : ?>
        <span class="key-value" style="margin-left:5px">
			 <i aria-hidden="true" class="fas fa-car"></i>
             <?php echo esc_html($vagas); ?> vagas
        </span>
	   <?php endif; ?>	
    </div>
</div>

		
		
    </div>

</div>
<style>
	.projectstatus span{
		background-color: var(--primary);
    padding: 10px 20px;
    gap: 10px;
    border-radius: 20px;
    font-weight: 600;
    font-size: 12px;
    line-height: 1.25;
    text-transform: uppercase;
    color: var(--accent);
    display: inline-flex;
    transition: all 0.3s ease;
	}
</style>

