<?php
get_header();

$options = get_option('spaciaz_project_archive');
$col_desktop = 3;
$col_tablet = 2;
$col_mobile = 1;
$gutter = 30;
$style = 'style-2';
$enable_filter = '';
$posts_per_page = 10;

$check_status = isset($_GET['status']) && !empty($_GET['status']);
$check_location = isset($_GET['location']) && !empty($_GET['location']);
$check_budget = isset($_GET['budget']) && !empty($_GET['budget']);
$check_project_type = isset($_GET['type']) && !empty($_GET['type']);
$wrap_class = 'col-full';

if ($options && is_array($options)) {
    $style = isset($options['archive_style']) ? $options['archive_style'] : 'style-2';
    $col_desktop = isset($options['columns_desktop']) ? $options['columns_desktop'] : 3;
    $col_tablet = isset($options['columns_tablet']) ? $options['columns_tablet'] : 2;
    $col_mobile = isset($options['columns_mobile']) ? $options['columns_mobile'] : 1;
    $gutter = isset($options['gutter']) ? $options['gutter'] : 30;
    $enable_filter = isset($options['filter_style']) ? $options['filter_style'] : '';
    $posts_per_page = isset($options['posts_per_page']) ? $options['posts_per_page'] : $posts_per_page;

    if ($style === 'style-3') {
        $col_desktop = 1;
        $col_tablet = 1;
        $col_mobile = 1;
    }
}
echo '<div class="project-archive-' . esc_attr($style) . ' ' . esc_attr($wrap_class) . '">'
?>

    <div id="primary" class="content-area">
        <main id="main" class="site-main" role="main">
            <?php
            $archive_class = $enable_filter ? 'has-filter-' . $enable_filter : '';
            ?>
            <div class="project-archive-content <?php echo esc_attr($archive_class); ?>">
                <?php
                if ($enable_filter) {
                    $archive_link = apply_filters('spaciaz_project_filters_archive_link', get_post_type_archive_link('spaciaz_project'));

                    echo '<div class="spaciaz-project-filter"><form method="get" class="project-form-filter spaciaz-project-' . esc_attr($archive_class) . '" action="' . esc_url($archive_link) . '">';
                    echo '<h4 class="filter-title">';
                    esc_html_e('Filter', 'spaciaz');
                    echo '</h4>';

                    $args = array(
                        'hide_empty' => false,
                        'order' => 'ASC',
                        'number' => 0,
                    );

                    $terms_status = get_terms('project_status', $args);
                    $status_selected = $check_status ? '' : 'selected';

                    if (!is_wp_error($terms_status) && !empty($terms_status)) {
                        echo '<select name="status">';
                        echo '<option ' . esc_attr($status_selected) . ' value="">' . esc_html('Status do Imóvel') . '</option>';
                        foreach ($terms_status as $term) {
                            $status_selected = '';
                            if ($check_status) {
                                $status = explode(',', $_GET['status']);
                                if (in_array($term->slug, $status)) {
                                    $status_selected = 'selected';
                                }
                            }
                            echo '<option ' . esc_attr($status_selected) . ' value="' . esc_attr($term->slug) . '">' . esc_html($term->name) . '</option>';
                        }
                        echo '</select>';

                    }

                    $terms_project_type = get_terms('project_type', $args);
                    $project_type_selected = $check_project_type ? '' : 'selected';
                    if (!is_wp_error($terms_project_type) && !empty($terms_project_type)) {
                        echo '<select name="type">';
                        echo '<option ' . esc_attr($project_type_selected) . ' value="">' . esc_html('Tipo do Imóvel') . '</option>';
                        foreach ($terms_project_type as $term) {
                            $project_type_selected = '';
                            if ($check_project_type) {
                                $project_type = explode(',', $_GET['type']);
                                if (in_array($term->slug, $project_type)) {
                                    $project_type_selected = 'selected';
                                }
                            }
                            echo '<option ' . esc_attr($project_type_selected) . ' value="' . esc_attr($term->slug) . '">' . esc_html($term->name) . '</option>';
                        }
                        echo '</select>';
                    }


                    $terms_location = get_terms('project_location', $args);
                    $location_selected = $check_location ? '' : 'selected';
                    if (!is_wp_error($terms_location) && !empty($terms_location)) {

                        echo '<select name="location">';
                        echo '<option ' . esc_attr($location_selected) . ' value="">' . esc_html('Localização') . '</option>';

                        foreach ($terms_location as $term) {
                            $location_selected = '';
                            if ($check_location) {
                                $location = explode(',', $_GET['location']);
                                if (in_array($term->slug, $location)) {
                                    $location_selected = 'selected';
                                }
                            }

                            echo '<option ' . esc_attr($location_selected) . ' value="' . esc_attr($term->slug) . '">' . esc_html($term->name) . '</option>';

                        }

                        echo '</select>';

                    }


                    $terms_budget = get_terms('project_budget', $args);
                    $budget_selected = $check_budget ? '' : 'selected';
                    if (!is_wp_error($terms_budget) && !empty($terms_budget)) {

                        echo '<select name="budget">';
                        echo '<option ' . esc_attr($budget_selected) . ' value="">' . esc_html('Valor') . '</option>';

                        foreach ($terms_budget as $term) {
                            $budget_selected = '';
                            if ($check_budget) {
                                $budget = explode(',', $_GET['budget']);
                                if (in_array($term->slug, $budget)) {
                                    $budget_selected = 'selected';
                                }
                            }

                            echo '<option ' . esc_attr($budget_selected) . ' value="' . esc_attr($term->slug) . '">' . esc_html($term->name) . '</option>';

                        }
                        echo '</select>';
                    }
                    echo '<div class="filter-wrap filter-wrap-button"><button type="submit">' . esc_html__('Pesquisar', 'spaciaz') . '</button></div>';
                    echo '</form> </div>';

                }
                ?>

                <div class="archive-content-inner">
                    <?php
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                    $args_query = array(
                        'post_type' => 'spaciaz_project',
                        'posts_per_page' => $posts_per_page,
                        'paged' => $paged,
                    );

                    if ($check_status || $check_project_type || $check_location || $check_budget) {
                        $args_query['tax_query'] = [];
                    }
                    $checked_count = 0;
                    if ($check_status) $checked_count++;
                    if ($check_project_type) $checked_count++;
                    if ($check_location) $checked_count++;
                    if ($check_budget) $checked_count++;

                    if ($checked_count >= 2) {
                        $args_query['tax_query']['relation'] = 'AND';
                    }

                    if ($check_status) {
                        $args_query['tax_query'][] = [
                            'taxonomy' => 'project_status',
                            'field' => 'slug',
                            'terms' => explode(',', $_GET['status']),
                            'operator' => 'IN'
                        ];
                    }

                    if ($check_project_type) {
                        $args_query['tax_query'][] = [
                            'taxonomy' => 'project_type',
                            'field' => 'slug',
                            'terms' => explode(',', $_GET['type']),
                            'operator' => 'IN'
                        ];
                    }

                    if ($check_location) {
                        $args_query['tax_query'][] = [
                            'taxonomy' => 'project_location',
                            'field' => 'slug',
                            'terms' => explode(',', $_GET['location']),
                            'operator' => 'IN'
                        ];
                    }

                    if ($check_budget) {
                        $args_query['tax_query'][] = [
                            'taxonomy' => 'project_budget',
                            'field' => 'slug',
                            'terms' => explode(',', $_GET['budget']),
                            'operator' => 'IN'
                        ];
                    }

                    $the_query = new WP_Query($args_query);

                    if ($the_query->have_posts()) :
                        echo '<div style="--gutter-width: ' . esc_attr($gutter) . 'px;" class="d-grid grid-columns-desktop-' . esc_attr($col_desktop) . ' grid-columns-tablet-' . esc_attr($col_tablet) . ' grid-columns-' . esc_attr($col_mobile) . '">';
                        while ($the_query->have_posts()) : $the_query->the_post();
                            global $post;
                            ?>
                            <div class="grid-item">
                                <?php get_template_part('template-parts/project/item-project', $style); ?>
                            </div>
                        <?php
                        endwhile;
                        echo '</div>';
                        echo '<div class="pagination">';
                        echo paginate_links(array(
                            'type' => 'list',
                            'current' => max(1, get_query_var('paged')),
                            'total' => $the_query->max_num_pages,
                            'prev_text' => esc_html__('', 'spaciaz'),
                            'next_text' => esc_html__('', 'spaciaz'),
                        ));
                        echo '</div>';

                        wp_reset_postdata();
                    else :
                        ?>
                        <div class="no-results not-found">
                            <h2 class="page-title"><?php esc_html_e('Nothing Found', 'spaciaz'); ?></h2>
                            <p><?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for.', 'spaciaz'); ?></p>
                        </div>
                    <?php
                    endif;
                    ?>
                </div>
            </div>
        </main><!-- #main -->
    </div><!-- #primary -->
<?php
echo '</div>';
get_footer();