<?php
/**
 * Template de Tipo de Negociação
 * taxonomy-project_negociacao.php
 */

get_header();

$term = get_queried_object();

$options = get_option('spaciaz_project_archive');

$col_desktop = 3;
$col_tablet  = 2;
$col_mobile  = 1;
$gutter      = 30;
$style       = 'style-2';

if ($options && is_array($options)) {
    $style       = $options['archive_style'] ?? 'style-2';
    $col_desktop = $options['columns_desktop'] ?? 3;
    $col_tablet  = $options['columns_tablet'] ?? 2;
    $col_mobile  = $options['columns_mobile'] ?? 1;
    $gutter      = $options['gutter'] ?? 30;
}
?>

<div class="negociacao-archive negociacao-<?php echo esc_attr($term->slug); ?>
     project-archive-<?php echo esc_attr($style); ?> col-full">

    <header class="archive-header" style="margin-bottom:40px;">
        <h1><?php echo esc_html($term->name); ?></h1>

        <?php if ($term->description): ?>
            <p><?php echo esc_html($term->description); ?></p>
        <?php endif; ?>
    </header>

    <div id="primary">
        <main id="main" class="site-main">

            <?php if (have_posts()) : ?>

                <div style="--gutter-width:<?php echo esc_attr($gutter); ?>px"
                     class="d-grid grid-columns-desktop-<?php echo esc_attr($col_desktop); ?>
                            grid-columns-tablet-<?php echo esc_attr($col_tablet); ?>
                            grid-columns-<?php echo esc_attr($col_mobile); ?>">

                    <?php while (have_posts()) : the_post(); ?>
                        <div class="grid-item">
                            <?php get_template_part('template-parts/project/item-project', $style); ?>
                        </div>
                    <?php endwhile; ?>

                </div>

                <div class="pagination">
                    <?php
                    echo paginate_links([
                        'type'    => 'list',
                        'current' => max(1, get_query_var('paged')),
                        'total'   => $wp_query->max_num_pages,
                    ]);
                    ?>
                </div>

            <?php else : ?>
                <p>Nenhum imóvel encontrado para este tipo de negociação.</p>
            <?php endif; ?>

        </main>
    </div>

</div>

<?php
get_footer();
