<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Spaciaz_Service
 */
class Spaciaz_Services {
    public $post_type = 'spaciaz_services';
    static $instance;

    public static function getInstance() {
        if (!isset(self::$instance) && !(self::$instance instanceof Spaciaz_Services)) {
            self::$instance = new Spaciaz_Services();
        }

        return self::$instance;
    }

    public function __construct() {
        add_action('init', [$this, 'create_services']);
        if (spaciaz_is_cmb2_activated()) {
            add_action('init', [$this, 'setup_metabox']);
        }
    }

    public function setup_metabox() {
        add_action('cmb2_admin_init', [$this, 'metabox_services']);
    }

    public function metabox_services() {
        $cmb2 = new_cmb2_box(array(
            'id'           => 'spaciaz_services_setting',
            'title'        => esc_html__('Infomation', 'spaciaz'),
            'object_types' => array('spaciaz_services'),
        ));

        $cmb2->add_field(array(
            'name'    => esc_html__('Service Icon', 'spaciaz'),
            'id'      => 'services_icon_class',
            'type'    => 'file',
            'options' => array(
                'url' => true,
            ),
        ));
    }


    /**
     * @return void
     */
    public function create_services() {

        $labels = array(
            'name'               => esc_html__('Services', 'spaciaz'),
            'singular_name'      => esc_html__('Service', 'spaciaz'),
            'add_new'            => esc_html__('Add New Service', 'spaciaz'),
            'add_new_item'       => esc_html__('Add New Service', 'spaciaz'),
            'edit_item'          => esc_html__('Edit Service', 'spaciaz'),
            'new_item'           => esc_html__('New Service', 'spaciaz'),
            'view_item'          => esc_html__('View Service', 'spaciaz'),
            'search_items'       => esc_html__('Search Services', 'spaciaz'),
            'not_found'          => esc_html__('No Services found', 'spaciaz'),
            'not_found_in_trash' => esc_html__('No Services found in Trash', 'spaciaz'),
            'parent_item_colon'  => esc_html__('Parent Service:', 'spaciaz'),
            'menu_name'          => esc_html__('Services', 'spaciaz'),
        );

        $labels     = apply_filters('spaciaz_services_labels', $labels);
        $slug_field = apply_filters('spaciaz_services_slug', 'services');

        spaciaz_function_to_call('post_type', [$this->post_type,
            array(
                'labels'        => $labels,
                'supports'      => array('title', 'editor', 'thumbnail', 'excerpt'),
                'public'        => true,
                'has_archive'   => false,
                'rewrite'       => array('slug' => $slug_field),
                'menu_position' => 5,
            )
            ]
        );
    }

}

Spaciaz_Services::getInstance();
