<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Spaciaz_Project
 */
class Spaciaz_Project
{
    public $post_type = 'spaciaz_project';
    static $instance;

    public static function getInstance()
    {
        if (!isset(self::$instance) && !(self::$instance instanceof Spaciaz_Project)) {
            self::$instance = new Spaciaz_Project();
        }

        return self::$instance;
    }

    public function __construct()
    {
        add_action('init', [$this, 'create_projects']);
        add_action('init', [$this, 'create_taxonomy']);

        add_action('cmb2_admin_init', [$this, 'spaciaz_register_theme_options_metabox']);
        add_action('wp_enqueue_scripts', array($this, 'scripts'), 10);

        add_action('template_redirect', [$this, 'project_taxonomy_redirect']);
    }

    function project_taxonomy_redirect()
    {
        if (is_tax('project_status') || is_tax('project_type') || is_tax('project_location') || is_tax('project_budget')) {
            $term = get_queried_object();
            $slug = $term->slug;
            $param = '';

            if (is_tax('project_status')) {
                $param = 'status';
            } elseif (is_tax('project_type')) {
                $param = 'type';
            } elseif (is_tax('project_location')) {
                $param = 'location';
            } elseif (is_tax('project_budget')) {
                $param = 'budget';
            }

            if ($param && $slug) {
                $url = get_post_type_archive_link('spaciaz_project') . '?' . $param . '=' . $slug;
                wp_redirect($url);
                exit;
            }
        }
    }

    public function scripts()
    {
        $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
        if (is_post_type_archive('spaciaz_project')) {
            wp_enqueue_script('spaciaz-archive-project', get_template_directory_uri() . '/assets/js/frontend/project' . $suffix . '.js', array('jquery'), SPACIAZ_VERSION, true);
        }
    }

    /**
     * @return void
     */
    public function create_projects()
    {

        $labels = array(
            'name' => esc_html__('Projects', 'spaciaz'),
            'singular_name' => esc_html__('Project', 'spaciaz'),
            'add_new' => esc_html__('Add Novo Imovel', 'spaciaz'),
            'add_new_item' => esc_html__('Add Novo Imovel', 'spaciaz'),
            'edit_item' => esc_html__('Editar Imovel', 'spaciaz'),
            'new_item' => esc_html__('Novo Imovel', 'spaciaz'),
            'view_item' => esc_html__('Ver Imovel', 'spaciaz'),
            'search_items' => esc_html__('Pesquisar Imoveis', 'spaciaz'),
            'not_found' => esc_html__('No Projects found', 'spaciaz'),
            'not_found_in_trash' => esc_html__('No Projects found in Trash', 'spaciaz'),
            'parent_item_colon' => esc_html__('Parent Project:', 'spaciaz'),
            'menu_name' => esc_html__('Imovel', 'spaciaz'),
        );

        $labels = apply_filters('spaciaz_project_labels', $labels);
        $slug_field = apply_filters('spaciaz_project_slug', 'projects');

        spaciaz_function_to_call('post_type', [$this->post_type,
                array(
                    'labels' => $labels,
                    'supports' => array('title', 'editor', 'thumbnail', 'excerpt'),
                    'public' => true,
                    'has_archive' => true,
                    'rewrite' => array('slug' => $slug_field),
                    'menu_position' => 5,
                    'categories' => array(),
                )
            ]
        );
    }

    public function create_taxonomy()
    {

        $slug_status_field = apply_filters('slug_project_status', 'project-status');
        $args_status = array(
            'hierarchical' => true,
            'label' => __('Status do Imovel', 'spaciaz'),
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => $slug_status_field),
            'show_ui' => true,
        );

        spaciaz_function_to_call('taxonomy', ['project_status', array($this->post_type), $args_status]);

        $slug_type_field = apply_filters('slug_project_type', 'project-type');
        $args_type = array(
            'hierarchical' => true,
            'label' => __('Tipo do Imovel', 'spaciaz'),
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => $slug_type_field),
            'show_ui' => true,
        );

        spaciaz_function_to_call('taxonomy', ['project_type', array($this->post_type), $args_type]);

        $slug_location_field = apply_filters('slug_project_location', 'project-location');
        $args_location = array(
            'hierarchical' => true,
            'label' => __('Localizacao do Imovel', 'spaciaz'),
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => $slug_location_field),
            'show_ui' => true,
        );

        spaciaz_function_to_call('taxonomy', ['project_location', array($this->post_type), $args_location]);

        $slug_budget_field = apply_filters('slug_project_budget', 'project-budget');
        $args_budget = array(
            'hierarchical' => true,
            'label' => __('Valor do Imovel', 'spaciaz'),
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => $slug_budget_field),
            'show_ui' => true,
        );

        spaciaz_function_to_call('taxonomy', ['project_budget', array($this->post_type), $args_budget]);
		
		/* ---------------------------------
         * TAXONOMY — PROJECT AREA (metragem)
         * --------------------------------- */
        $slug_area_field = apply_filters('slug_project_area', 'project-area');
        $args_area = array(
            'hierarchical'      => true,
            'label'             => __('Area do Imovel', 'spaciaz'),
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array('slug' => $slug_area_field),
            'show_ui'           => true,
        );

        spaciaz_function_to_call('taxonomy', ['project_area', array($this->post_type), $args_area]);
		
		/* ---------------------------------
         * TAXONOMY — UNIDADES BADEN
         * --------------------------------- */
        $slug_unidades_field = apply_filters('slug_unidades_baden', 'unidades-baden');
        $args_unidades = array(
            'hierarchical'      => true,
            'label'             => __('Unidades Baden', 'spaciaz'),
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array('slug' => $slug_unidades_field),
            'show_ui'           => true,
        );

        spaciaz_function_to_call('taxonomy', ['unidades_baden', array($this->post_type), $args_unidades]);
		
		/* ---------------------------------
 * TAXONOMY — TIPO DE NEGOCIAÇÃO
 * --------------------------------- */
$slug_negociacao_field = apply_filters('slug_project_negociacao', 'project-negociacao');

$args_negociacao = array(
    'hierarchical'      => true,
    'label'             => __('Tipo de Negociação', 'spaciaz'),
    'show_admin_column' => true,
    'query_var'         => true,
    'rewrite'           => array('slug' => $slug_negociacao_field),
    'show_ui'           => true,
);

spaciaz_function_to_call(
    'taxonomy',
    ['project_negociacao', array($this->post_type), $args_negociacao]
);



	

    }


    public function spaciaz_register_theme_options_metabox()
    {

        /**
         * Registers options page menu item and form.
         */
        $cmb2 = new_cmb2_box(array(
            'id' => 'spaciaz_project_archive',
            'title' => esc_html__('Projects Setting', 'spaciaz'),
            'object_types' => array('options-page'),
            'option_key' => 'spaciaz_project_archive',
            'position' => 8,
        ));

        $cmb2->add_field(array(
            'name' => esc_html__('Archive Style', 'spaciaz'),
            'id' => 'archive_style',
            'type' => 'select',
            'show_option_none' => true,
            'default' => 'style-2',
            'options' => array(
                'style-1' => esc_html__('Style 1', 'spaciaz'),
                'style-2' => esc_html__('Style 2', 'spaciaz'),
                'style-3' => esc_html__('Style 3', 'spaciaz'),
                'style-4' => esc_html__('Style 4', 'spaciaz'),
            ),
        ));

        $cmb2->add_field(array(
            'name' => esc_html__('Filter', 'spaciaz'),
            'id' => 'filter_style',
            'type' => 'select',
            'show_option_none' => true,
            'default' => '',
            'options' => array(
                '' => esc_html__('None', 'spaciaz'),
                'style-1' => esc_html__('Style 1', 'spaciaz'),
            ),
        ));

        $cmb2->add_field(array(
            'name' => esc_html__('Columns Desktop', 'spaciaz'),
            'id' => 'columns_desktop',
            'type' => 'select',
            'show_option_none' => true,
            'default' => '3',
            'options' => array(
                '1' => '1',
                '2' => '2',
                '3' => '3',
            ),
        ));
        $cmb2->add_field(array(
            'name' => esc_html__('Columns Tablet', 'spaciaz'),
            'id' => 'columns_tablet',
            'type' => 'select',
            'show_option_none' => true,
            'default' => '2',
            'options' => array(
                '1' => '1',
                '2' => '2',
                '3' => '3',
            ),
        ));

        $cmb2->add_field(array(
            'name' => esc_html__('Columns Mobile', 'spaciaz'),
            'id' => 'columns_mobile',
            'type' => 'select',
            'show_option_none' => true,
            'default' => '1',
            'options' => array(
                '1' => '1',
                '2' => '2',
                '3' => '3',
            ),
        ));

        $cmb2->add_field(array(
            'name' => __('Gutter (px)', 'spaciaz'),
            'id' => 'gutter',
            'type' => 'text',
            'default' => 30,
        ));

        $cmb2->add_field(array(
            'name' => __('Posts Per Page', 'spaciaz'),
            'id' => 'posts_per_page',
            'type' => 'text',
            'default' => 10,
        ));
    }

}
/**
 * META BOX – FEATURES BLOCK (4 itens com ícone + texto)
 */

add_action('cmb2_admin_init', 'spaciaz_register_project_features_metabox');
function spaciaz_register_project_features_metabox(){

    $prefix = '_spaciaz_project_';

    $cmb = new_cmb2_box(array(
        'id'           => $prefix . 'features_box',
        'title'        => 'Features do Projeto (cards com ícones)',
        'object_types' => array('spaciaz_project'), // <<< IMPORTANTE: CPT singular
    ));

    $group = $cmb->add_field(array(
        'id'          => $prefix . 'features',
        'type'        => 'group',
        'description' => 'Adicionar features do projeto (ex: Segurança, Estacionamento, Piscina...)',
        'repeatable'  => true,
        'options'     => array(
            'group_title'   => 'Feature {#}',
            'add_button'    => 'Adicionar Feature',
            'remove_button' => 'Remover Feature',
            'sortable'      => true,
        ),
    ));

    // Ícone (fontawesome class)
    $cmb->add_group_field($group, array(
        'name' => 'Ícone (classe FontAwesome)',
        'id'   => 'icon',
        'type' => 'text',
        'default' => 'fas fa-check-circle'
    ));

    // Nome
    $cmb->add_group_field($group, array(
        'name' => 'Título',
        'id'   => 'title',
        'type' => 'text',
    ));
}

Spaciaz_Project::getInstance();

/* ---- ADMIN COLUMN: ÁREA DO IMÓVEL ---- */

add_filter('manage_spaciaz_project_posts_columns', function($columns) {
    $columns['project_area'] = 'Área do Imóvel';
    return $columns;
});

add_action('manage_spaciaz_project_posts_custom_column', function($column, $post_id){
    if ($column === 'project_area') {
        $terms = wp_get_post_terms($post_id, 'project_area');
        echo !empty($terms) ? esc_html($terms[0]->name) : '—';
    }
}, 10, 2);

add_filter('manage_edit-spaciaz_project_sortable_columns', function($columns){
    $columns['project_area'] = 'project_area';
    return $columns;
});
