<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;

class Spaciaz_Elementor_Team_Box extends Spaciaz_Base_Widgets_Swiper
{


    public function get_name()
    {
        return 'spaciaz-team-box';
    }


    public function get_title()
    {
        return esc_html__('Spaciaz Team Box', 'spaciaz');
    }


    public function get_icon()
    {
        return 'eicon-person';
    }

    public function get_script_depends()
    {
        return ['spaciaz-elementor-team-box', 'spaciaz-elementor-swiper'];
    }

    public function get_categories()
    {
        return array('spaciaz-addons');
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_team',
            [
                'label' => esc_html__('Team', 'spaciaz'),
            ]
        );
        $repeater = new Repeater();


        $repeater->add_control(
            'teambox_image',
            [
                'label' => esc_html__('Choose Image', 'spaciaz'),
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
            ]
        );

        $repeater->add_control(
            'teambox_name',
            [
                'label' => esc_html__('Name', 'spaciaz'),
                'default' => 'John Doe',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'teambox_job',
            [
                'label' => esc_html__('Job', 'spaciaz'),
                'default' => 'Designer',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'teambox_link',
            [
                'label' => esc_html__('Link to', 'spaciaz'),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'spaciaz'),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $repeater->add_control(
            'facebook',
            [
                'label' => esc_html__('Facebook', 'spaciaz'),
                'placeholder' => esc_html__('https://www.facebook.com/opalwordpress', 'spaciaz'),
                'default' => 'https://www.facebook.com/opalwordpress',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'instagram',
            [
                'label' => esc_html__('Instagram', 'spaciaz'),
                'placeholder' => esc_html__('https://www.instagram.com/user/WPOpalTheme', 'spaciaz'),
                'default' => 'https://www.instagram.com/user/WPOpalTheme',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'twitter',
            [
                'label' => esc_html__('Twitter', 'spaciaz'),
                'placeholder' => esc_html__('https://twitter.com/opalwordpress', 'spaciaz'),
                'default' => 'https://twitter.com/opalwordpress',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'teambox',
            [
                'label' => esc_html__('Items', 'spaciaz'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'teambox_image',
                'default' => 'full',
                'separator' => 'none',
            ]
        );

        $this->add_responsive_control(
            'column',
            [
                'label' => esc_html__('Columns', 'spaciaz'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 1,
                'options' => [1 => 1, 2 => 2, 3 => 3, 4 => 4, 6 => 6],
                'selectors' => [
                    '{{WRAPPER}} .d-grid' => 'grid-template-columns: repeat({{VALUE}}, 1fr)',
                ],
                'condition' => ['enable_carousel!' => 'yes']
            ]
        );

        $this->add_responsive_control(
            'teambox_gutter',
            [
                'label' => esc_html__('Gutter', 'spaciaz'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .d-grid' => 'grid-gap:{{SIZE}}{{UNIT}}',
                ],
                'condition' => ['enable_carousel!' => 'yes']
            ]
        );

        $this->add_control(
            'enable_carousel',
            [
                'label' => esc_html__('Enable Carousel', 'spaciaz'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_responsive_control(
            'teambox_odd_top',
            [
                'label' => esc_html__('Padding Top', 'spaciaz'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-teambox-item:nth-child(even)' => 'padding-top:{{SIZE}}{{UNIT}}',
                ],
                'condition' => ['enable_carousel' => 'yes'],
                'description' => 'Apply to even positions.'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'teambox_style_image',
            [
                'label' => esc_html__('Image', 'spaciaz'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'spaciaz'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .team-image-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_margin',
            [
                'label' => esc_html__('Margin', 'spaciaz'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .team-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'teambox_style_content',
            [
                'label' => esc_html__('Content', 'spaciaz'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => esc_html__('Padding', 'spaciaz'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .team-infor' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_margin',
            [
                'label'      => esc_html__('Margin', 'spaciaz'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .team-infor' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_bgcolor',
            [
                'label' => esc_html__('Background Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-infor' => 'background: {{VALUE}};',
                ],

            ]
        );

        $this->add_control(
            'heading_name',
            [
                'label' => esc_html__('Name', 'spaciaz'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-name' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .team-name a' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_control(
            'name_color_hover',
            [
                'label' => esc_html__('Color Hover', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-name a:hover' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .team-name',

            ]
        );

        $this->add_control(
            'heading_job',
            [
                'label' => esc_html__('Job', 'spaciaz'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'job_color',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-job' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'job_typography',
                'selector' => '{{WRAPPER}} .team-job',

            ]
        );

        $this->add_control(
            'heading_social',
            [
                'label' => esc_html__('Social', 'spaciaz'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'social_color',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-icon-socials ul a' => 'color: {{VALUE}};',
                ],

            ]
        );
        $this->add_control(
            'social_color_hover',
            [
                'label' => esc_html__('Color Hover', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-icon-socials ul a:hover' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'teambox_style_button',
            [
                'label' => esc_html__('Button', 'spaciaz'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_width',
            [
                'label' => esc_html__('Size Icon', 'spaciaz'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .team-link svg' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .team-link i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_button_style');

        $this->start_controls_tab(
            'tab_button_normal',
            [
                'label' => esc_html__('Normal', 'spaciaz'),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-link .btn-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .team-link .btn-icon-hover' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_control(
            'button_bgcolor',
            [
                'label' => esc_html__('Background Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-link' => 'background-color: {{VALUE}};',
                ],

            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_button_hover',
            [
                'label' => esc_html__('Hover', 'spaciaz'),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-link:hover .btn-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .team-link:hover .btn-icon-hover' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_control(
            'button_bgcolor_hover',
            [
                'label' => esc_html__('Background Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .team-link:hover' => 'background-color: {{VALUE}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
        $this->add_control_carousel(['enable_carousel' => 'yes']);

    }

    /**
     * Render teambox widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (empty($settings['teambox'])) {
            return;
        }

        $this->add_render_attribute('wrapper', 'class', 'elementor-teambox-item-wrapper');
        $this->add_render_attribute('row', 'class');
        $this->get_data_elementor_columns();
        // Item
        $this->add_render_attribute('item', 'class', 'elementor-teambox-item');
        $this->add_render_attribute('details', 'class', 'teambox-details');
        ?>

        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <div <?php $this->print_render_attribute_string('row'); ?>>
                <?php foreach ($settings['teambox'] as $teambox): ?>
                    <div <?php $this->print_render_attribute_string('item'); ?>>
                        <div class="team-item">
                            <?php if (!empty($teambox['teambox_link']['url'])) : ?>
                                <a class="team-link elementor-button-icon" href="<?php echo esc_url($teambox['teambox_link']['url']); ?>">
                                    <span class="btn-icon-wrap">
                                        <span class="btn-icon"><i class="spaciaz-icon-arrow-long-right"></i></span>
                                        <span class="btn-icon-hover"><i class="spaciaz-icon-arrow-long-right"></i></span>
                                    </span>
                                </a>
                            <?php endif; ?>
                            <?php $this->render_image($settings, $teambox); ?>
                            <div class="team-infor">
                                <?php if (!empty($teambox['teambox_job'])) : ?>
                                    <div class="team-job"><?php echo esc_html($teambox['teambox_job']); ?></div>
                                <?php endif; ?>

                                <h5 class="team-name">
                                    <?php
                                    $teambox_name_html = !empty($teambox['teambox_link']['url'])
                                        ? sprintf('<a href="%s">%s</a>', esc_url($teambox['teambox_link']['url']), esc_html($teambox['teambox_name']))
                                        : esc_html($teambox['teambox_name']);
                                    printf('%s', $teambox_name_html);
                                    ?>
                                </h5>

                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php $this->render_swiper_pagination_navigation(); ?>
        <?php
    }

    private function render_image($settings, $teambox)
    {
        if (!empty($teambox['teambox_image']['url'])) :
            ?>
            <div class="team-image">
                <div class="team-box-socials-wrapper">
                    <div class="team-icon-socials">
                        <ul>
                            <?php foreach ($this->get_socials() as $key => $social): ?>
                                <?php if (!empty($teambox[$key])) : ?>
                                    <li class="social">
                                        <a href="<?php echo esc_url($teambox[$key]) ?>">
                                            <i class="spaciaz-icon-<?php echo esc_attr($social); ?>"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
                <div class="team-image-inner">
                    <div class="decor_border"> </div>
                    <?php
                    $teambox['teambox_image_size'] = $settings['teambox_image_size'];
                    $teambox['teambox_image_custom_dimension'] = $settings['teambox_image_custom_dimension'];
                    echo Group_Control_Image_Size::get_attachment_image_html($teambox, 'teambox_image');
                    ?>
                </div>
            </div>
        <?php
        endif;
    }

    private function get_socials()
    {
        return array(
            'facebook' => 'facebook-f',
            'instagram' => 'instagram',
            'twitter' => 'twitter-x',
        );
    }

}

$widgets_manager->register(new Spaciaz_Elementor_Team_Box());