<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;


/**
 * Class Spaciaz_Elementor_Project_Scroll
 */
class Spaciaz_Elementor_Project_Scroll extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'spaciaz-projects-scroll';
    }

    public function get_title()
    {
        return esc_html__('Spaciaz Project Scroll', 'spaciaz');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-posts-grid';
    }

    public function get_categories()
    {
        return array('spaciaz-addons');
    }

    public function get_script_depends()
    {
        return ['spaciaz-elementor-projects-scroll'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_query',
            [
                'label' => esc_html__('Project Scroll', 'spaciaz'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('Posts Per Page', 'spaciaz'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'includes_ids',
            [
                'label' => esc_html__('Includes', 'spaciaz'),
                'type' => 'spaciaz_query',
                'autocomplete' => [
                    'object' => 'spaciaz_project',
                ],
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $this->add_control(
            'excludes_ids',
            [
                'label' => esc_html__('Excludes', 'spaciaz'),
                'type' => 'spaciaz_query',
                'autocomplete' => [
                    'object' => 'spaciaz_project',
                ],
                'label_block' => true,
                'multiple' => true,
            ]
        );


        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('Order By', 'spaciaz'),
                'type' => Controls_Manager::SELECT,
                'default' => 'post_date',
                'options' => [
                    'post_date' => esc_html__('Date', 'spaciaz'),
                    'post_title' => esc_html__('Title', 'spaciaz'),
                    'menu_order' => esc_html__('Menu Order', 'spaciaz'),
                    'rand' => esc_html__('Random', 'spaciaz'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('Order', 'spaciaz'),
                'type' => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'asc' => esc_html__('ASC', 'spaciaz'),
                    'desc' => esc_html__('DESC', 'spaciaz'),
                ],
            ]
        );

        $this->add_control(
            'project_subtitle',
            [
                'label' => esc_html__('Sub Title', 'spaciaz'),
                'type' => Controls_Manager::TEXT,
                'default' => 'Sub Title',
            ]
        );

        $this->add_control(
            'project_heading',
            [
                'label' => esc_html__('Title', 'spaciaz'),
                'type' => Controls_Manager::TEXT,
                'default' => 'Title',
            ]
        );


        $this->end_controls_section();


        // Subtitle.
        $this->start_controls_section(
            'style_sub_project',
            [
                'label' => esc_html__('Sub Title', 'spaciaz'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .project-subtitle' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .project-subtitle span:before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .project-subtitle',
            ]
        );

        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'size_units' => ['px', 'em', '%'],
                'label' => esc_html__('Spacing', 'spaciaz'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .project-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Heading.
        $this->start_controls_section(
            'style_heading_project',
            [
                'label' => esc_html__('Heading', 'spaciaz'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .project-heading' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typography',
                'selector' => '{{WRAPPER}} .project-heading',
            ]
        );

        $this->add_responsive_control(
            'heading_spacing',
            [
                'size_units' => ['px', 'em', '%'],
                'label' => esc_html__('Spacing', 'spaciaz'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .project-heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__('Content', 'spaciaz'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => esc_html__('Padding', 'spaciaz'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .project-scroll-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_title',
            [
                'label' => esc_html__('Title', 'spaciaz'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_title_color',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .project-scroll-content .project-title a' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_control(
            'content_title_color_hover',
            [
                'label' => esc_html__('Color Hover', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .project-scroll-content .project-title a:hover' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_title_typography',
                'selector' => '{{WRAPPER}} .project-title',
            ]
        );


        $this->add_control(
            'content_location',
            [
                'label' => esc_html__('Location', 'spaciaz'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'content_location_color',
            [
                'label' => esc_html__('Color', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .project-scroll-content .project-location a' => 'color: {{VALUE}};',
                ],

            ]
        );
        $this->add_control(
            'content_location_color_hover',
            [
                'label' => esc_html__('Color Hover', 'spaciaz'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .project-scroll-content .project-location a:hover' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_location_typography',
                'selector' => '{{WRAPPER}} .project-location a',
            ]
        );

        $this->end_controls_section();

    }

    public static function get_query_args($settings)
    {
        $query_args = [
            'post_type' => 'spaciaz_project',
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
            'ignore_sticky_posts' => 1,
            'post__in' => $settings['includes_ids'],
            'post__not_in' => $settings['excludes_ids'],
            'post_status' => 'publish',
        ];
        $query_args['posts_per_page'] = $settings['posts_per_page'];
        return $query_args;
    }

    public function query_posts()
    {
        $query_args = $this->get_query_args($this->get_settings());
        return new WP_Query($query_args);
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('wrapper', 'class', 'elementor-project-scroll-wrapper');
        $this->add_render_attribute('row', 'class', 'elementor-project-scroll');
        $query = $this->query_posts();
        if (!$query->found_posts) {
            return;
        }
        $scrollcontent_html = '';

        ?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <div <?php $this->print_render_attribute_string('row'); ?>>
                <div class="project-scroll-image">
                    <?php
                    while ($query->have_posts()) {
                        $query->the_post();
                        ?>
                        <div class=" project-image-inner">
                            <div class="project-post-thumbnail">
                                <?php if (has_post_thumbnail()) : ?>
                                    <?php the_post_thumbnail('spaciaz-project'); ?>
                                <?php endif; ?>
                                <div class="project-button-wrap">
                                    <a class="project-button button" href="<?php the_permalink() ?>">
                                        <span><?php echo esc_html_e('View Project', 'spaciaz'); ?></span>
                                    </a>
                                </div>

                            </div><!-- .post-thumbnail -->
                        </div>
                        <?php
                        ob_start();
                        ?>
                        <div class="project-content-inner">
                            <?php echo get_the_term_list(get_the_ID(), 'project_location', '<div class="project-location"><i class="spaciaz-icon-marker"></i>', ' ', '</div>'); ?>
                            <h4 class="project-title delta"><a
                                        href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        </div>
                        <?php
                        $scrollcontent_html .= ob_get_clean();
                    }
                    ?>
                </div>
                <div class="project-scroll-content">
                    <?php if (!empty($settings['project_subtitle'])) {
                        ?>
                        <div class="project-subtitle">
                            <div class="project-subtitle-wrap">
                            <div class="subtitle-inner">
                                <?php
                                for ($i = 1; $i <= 3; $i++) {
                                    ?>
                                    <span><?php echo esc_html($settings['project_subtitle']); ?></span>
                                    <?php
                                }
                                ?>
                            </div>
                            </div>
                        </div>
                    <?php } ?>
                    <?php if (!empty($settings['project_heading'])) { ?>
                        <h2 class="project-heading"><?php echo esc_html($settings['project_heading']); ?></h2>
                    <?php } ?>
                    <?php
                    printf('%s', $scrollcontent_html);
                    ?>
                </div>
            </div>

        </div>
        <?php
        wp_reset_postdata();

    }
}

$widgets_manager->register(new Spaciaz_Elementor_Project_Scroll());