<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;


/**
 * Class Spaciaz_Elementor_Project_Navigation
 */
class Spaciaz_Elementor_Project_Navigation extends Elementor\Widget_Base {

    public function get_name() {
        return 'spaciaz-projects-navigation';
    }

    public function get_title() {
        return esc_html__('Spaciaz Project Navigation', 'spaciaz');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return array('spaciaz-addons');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_query',
            [
                'label' => esc_html__('Project Navigation', 'spaciaz'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $prev_post = get_previous_post(false, '', 'project_type');
        $next_post = get_next_post(false, '', 'project_type');
        $args      = ['taxonomy' => 'project_type'];


        if ($next_post) {
            $args['next_text'] = '<span class="nav-content"><span class="reader-text">' . esc_html__('next project', 'spaciaz') . '</span></span>';
        }
        if ($prev_post) {
            $args['prev_text'] = '<span class="nav-content"><span class="reader-text">' . esc_html__('previous project', 'spaciaz') . '</span></span> ';
        }

        the_post_navigation($args);
    }

}

$widgets_manager->register(new Spaciaz_Elementor_Project_Navigation());