<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;


/**
 * Class Spaciaz_Elementor_Project_Expand
 */
class Spaciaz_Elementor_Project_Expand extends \Elementor\Widget_Base {

    public function get_name() {
        return 'spaciaz-projects-expand';
    }

    public function get_title() {
        return esc_html__('Spaciaz Project Expand', 'spaciaz');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'eicon-carousel';
    }

    public function get_categories() {
        return array('spaciaz-addons');
    }

    public function get_script_depends() {
        return ['spaciaz-elementor-projects-expand'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_query',
            [
                'label' => esc_html__('Project', 'spaciaz'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label'   => esc_html__('Posts Per Page', 'spaciaz'),
                'type'    => Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'includes_ids',
            [
                'label'       => esc_html__('Includes', 'spaciaz'),
                'type' => 'spaciaz_query',
                'autocomplete' => [
                    'object' => 'spaciaz_project',
                ],
                'label_block' => true,
                'multiple'    => true,
            ]
        );

        $this->add_control(
            'excludes_ids',
            [
                'label'       => esc_html__('Excludes', 'spaciaz'),
                'type' => 'spaciaz_query',
                'autocomplete' => [
                    'object' => 'spaciaz_project',
                ],
                'label_block' => true,
                'multiple'    => true,
            ]
        );

        $this->add_control(
            'project_style',
            [
                'label'        => esc_html__('Style', 'spaciaz'),
                'type'         => \Elementor\Controls_Manager::SELECT,
                'options'      => [
                    'project-style-5' => esc_html__('Style 1', 'spaciaz'),
                    'project-style-7' => esc_html__('Style 2', 'spaciaz'),
                ],
                'render_type'  => 'template',
                'default'      => 'project-style-5',
                'prefix_class' => 'elementor-'
            ]
        );


        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order By', 'spaciaz'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'post_date',
                'options' => [
                    'post_date'  => esc_html__('Date', 'spaciaz'),
                    'post_title' => esc_html__('Title', 'spaciaz'),
                    'menu_order' => esc_html__('Menu Order', 'spaciaz'),
                    'rand'       => esc_html__('Random', 'spaciaz'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label'   => esc_html__('Order', 'spaciaz'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'asc'  => esc_html__('ASC', 'spaciaz'),
                    'desc' => esc_html__('DESC', 'spaciaz'),
                ],
            ]
        );
        $this->add_responsive_control(
            'item_spacing',
            [
                'label'      => esc_html__('Spacing', 'spaciaz'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'size' => 10
                ],
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .d-grid' => 'grid-gap:{{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_height',
            [
                'label' => esc_html__('Height', 'spaciaz'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => 'px',
                ],
                'size_units' => ['px', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .project-post-thumbnail' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    public static function get_query_args($settings) {
        $query_args = [
            'post_type'           => 'spaciaz_project',
            'orderby'             => $settings['orderby'],
            'order'               => $settings['order'],
            'ignore_sticky_posts' => 1,
            'post__in'            => $settings['includes_ids'],
            'post__not_in'        => $settings['excludes_ids'],
            'post_status'         => 'publish',
        ];
        $query_args['posts_per_page'] = $settings['posts_per_page'];
        return $query_args;
    }

    public function query_posts() {
        $query_args = $this->get_query_args($this->get_settings());
        return new WP_Query($query_args);
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $style = $settings['project_style'];
        $this->add_render_attribute('wrapper', 'class', 'elementor-project-expand-wrapper');
        $this->add_render_attribute('row', 'class', 'd-grid');
        $cards_count = max(2, intval($settings['posts_per_page']));
        $this->add_render_attribute('row', 'style', '--cards-count:' . $cards_count . ';');
        $this->add_render_attribute('item', 'class', 'grid-item project-inner ');
        $query = $this->query_posts();
        if (!$query->found_posts) {
            return;
        }

        ?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <div <?php $this->print_render_attribute_string('row'); ?>>
                <?php
                while ($query->have_posts()) {
                    $query->the_post();
                    ?>
                    <div <?php $this->print_render_attribute_string('item'); ?>>
                        <?php include get_theme_file_path('template-parts/project/item-' . $style . '.php'); ?>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
        <?php
        wp_reset_postdata();

    }
}

$widgets_manager->register(new Spaciaz_Elementor_Project_Expand());