<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;

class Spaciaz_Elementor__Menu_Canvas extends Elementor\Widget_Base {

    public function get_name() {
        return 'spaciaz-menu-canvas';
    }

    public function get_title() {
        return esc_html__('Spaciaz Menu Canvas', 'spaciaz');
    }

    public function get_icon() {
        return 'eicon-nav-menu';
    }

    public function get_categories() {
        return ['spaciaz-addons'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'icon-menu_style',
            [
                'label' => esc_html__('Menu Canvas', 'spaciaz'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );

        $this->add_control(
            'cavasmenu_icon',
            [
                'label'   => esc_html__('Menu Icon', 'spaciaz'),
                'type'    => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'spaciaz-icon-bars',
                    'library' => 'spaciaz-icon',
                ],
            ]
        );

        $this->add_control(
            'menu_color',
            [
                'label'     => esc_html__('Color', 'spaciaz'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .menu-mobile-nav-button .spaciaz-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'menu_color_hover',
            [
                'label'     => esc_html__('Color Hover', 'spaciaz'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .menu-mobile-nav-button:hover .spaciaz-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'size',
            [
                'label' => esc_html__( 'Size', 'spaciaz' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .menu-mobile-nav-button .spaciaz-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .menu-mobile-nav-button .spaciaz-icon svg' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'fit_to_size',
            [
                'label' => esc_html__( 'Fit to Size', 'spaciaz' ),
                'type' => Controls_Manager::SWITCHER,
                'description' => 'Avoid gaps around icons when width and height aren\'t equal',
                'label_off' => esc_html__( 'Off', 'spaciaz' ),
                'label_on' => esc_html__( 'On', 'spaciaz' ),
                'condition' => [
                    'cavasmenu_icon[library]' => 'svg',
                ],
                'selectors' => [
                    '{{WRAPPER}} .menu-mobile-nav-button .spaciaz-icon svg' => 'width: 100%;',
                ],
            ]
        );

        $this->add_control(
            'icon_padding',
            [
                'label' => esc_html__( 'Padding', 'spaciaz' ),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .menu-mobile-nav-button .spaciaz-icon' => 'padding: {{SIZE}}{{UNIT}};',
                ],
                'range' => [
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'rotate',
            [
                'label' => esc_html__( 'Rotate', 'spaciaz' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'deg', 'grad', 'rad', 'turn', 'custom' ],
                'default' => [
                    'unit' => 'deg',
                ],
                'tablet_default' => [
                    'unit' => 'deg',
                ],
                'mobile_default' => [
                    'unit' => 'deg',
                ],
                'selectors' => [
                    '{{WRAPPER}} .menu-mobile-nav-button .spaciaz-icon i, {{WRAPPER}} .menu-mobile-nav-button .spaciaz-icon svg' => 'transform: rotate({{SIZE}}{{UNIT}});',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('wrapper', 'class', 'elementor-canvas-menu-wrapper');
        ?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <a href="#" class="menu-mobile-nav-button">
                <div class="spaciaz-icon">
                    <?php \Elementor\Icons_Manager::render_icon($settings['cavasmenu_icon']); ?>
                </div>
            </a>
        </div>
        <?php
    }

}

$widgets_manager->register(new Spaciaz_Elementor__Menu_Canvas());
