<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

class Spaciaz_Elementor_Careers_Showcase extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve careersshowcase widget name.
     *
     * @return string Widget name.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'spaciaz-careers-showcase';
    }

    /**
     * Get widget title.
     *
     * Retrieve careersshowcase widget title.
     *
     * @return string Widget title.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_title() {
        return esc_html__('Spaciaz Careers Showcase', 'spaciaz');
    }

    /**
     * Get widget icon.
     *
     * Retrieve careersshowcase widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'eicon-person';
    }

    public function get_script_depends() {
        return ['magnific-popup','spaciaz-elementor-careers-showcase'];
    }

    public function get_style_depends() {
        return ['magnific-popup'];
    }

    public function get_categories() {
        return array('spaciaz-addons');
    }

    /**
     * Register careersshowcase widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_careers',
            [
                'label' => esc_html__('Careers', 'spaciaz'),
            ]
        );
        $repeater = new Repeater();

        $repeater->add_control(
            'careersshowcase_title',
            [
                'label'   => esc_html__('Title', 'spaciaz'),
                'type'    => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => esc_html__( 'This is the heading', 'spaciaz' ),
                'placeholder' => esc_html__( 'Enter your title', 'spaciaz' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'careersshowcase_time',
            [
                'label'   => esc_html__('Time', 'spaciaz'),
                'default' => 'Full time',
                'type'    => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'careersshowcase_hours',
            [
                'label'   => esc_html__('Working Hours', 'spaciaz'),
                'default' => '09:00 am - 05:00pm',
                'type'    => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'careersshowcase_location',
            [
                'label'   => esc_html__('Location', 'spaciaz'),
                'default' => '',
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'careersshowcase_description',
            [
                'label'       => esc_html__('Description', 'spaciaz'),
                'type'        => Controls_Manager::WYSIWYG,
                'default'     => esc_html__('Lorem ipsum lobortis amet sit tristique quisque id nunc eu consectetur velit diam mi donec eu nunc laoreet cras vel tempor in felis lorem ipsum id non.', 'spaciaz'),
                'placeholder' => esc_html__('Enter your description', 'spaciaz'),
                'separator'   => 'none',
                'rows'        => 5,
            ]
        );

        $repeater->add_control(
            'careersshowcase_textlink',
            [
                'label' => esc_html__('Text Link', 'spaciaz'),
                'default' => 'Apply Now',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'careersshowcase_link',
            [
                'label' => esc_html__('Link', 'spaciaz'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'spaciaz'),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'careersshowcase',
            [
                'label' => esc_html__('Items', 'spaciaz'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ careersshowcase_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content_style',
            [
                'label' => esc_html__('Item', 'spaciaz'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'spaciaz'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-careersshowcase-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .elementor-careersshowcase-item',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'spaciaz'),
                'tab' => Controls_Manager::TAB_STYLE,

            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Text Color', 'spaciaz'),
                'type'      => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .elementor-careersshowcase-item .careers-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography_title',
                'global'   => [
                    'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
                ],
                'selector' => '{{WRAPPER}} .elementor-careersshowcase-item .careers-title',
            ]
        );

        $this->add_control(
            'heading_time',
            [
                'label' => esc_html__( 'Time', 'spaciaz' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'time_color',
            [
                'label'     => esc_html__('Text Color', 'spaciaz'),
                'type'      => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .elementor-careersshowcase-item .careers-time' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography_time',
                'global'   => [
                    'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
                ],
                'selector' => '{{WRAPPER}} .elementor-careersshowcase-item .careers-time',
            ]
        );

        $this->add_control(
            'heading_location',
            [
                'label' => esc_html__( 'Location', 'spaciaz' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'location_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'spaciaz'),
                'type'      => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .elementor-careersshowcase-item .careers-location i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'location_color',
            [
                'label'     => esc_html__('Text Color', 'spaciaz'),
                'type'      => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .elementor-careersshowcase-item .careers-location' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography_location',
                'global'   => [
                    'default' => Global_Typography::TYPOGRAPHY_SECONDARY,
                ],
                'selector' => '{{WRAPPER}} .elementor-careersshowcase-item .careers-location',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render careersshowcase widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        if (empty($settings['careersshowcase'])) {
            return;
        }

        $this->add_render_attribute('wrapper', 'class', 'elementor-careersshowcase-item-wrapper');
        $this->add_render_attribute('content', 'class', 'elementor-careersshowcase-content');
        $slide_html = '';
        $id_int = substr($this->get_id_int(), 0, 3);
        ?>

        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <div <?php $this->print_render_attribute_string('content'); ?>>
                <?php foreach ($settings['careersshowcase'] as $index => $careersshowcase):
                    $count = $index + 1;
                    $item_title_setting_key = $this->get_repeater_setting_key('item_title', 'items', $index);
                    $this->add_render_attribute($item_title_setting_key, [
                        'id'            => 'elementor-careersshowcase-title-' . $id_int . $count,
                        'class'         => [
                            'elementor-careersshowcase-item',
                            'elementor-repeater-item-' . $careersshowcase['_id'],
                            ($index == 0) ? 'elementor-active' : '',
                        ],
                        'data-goto'     =>  $index,
                        'data-tab'      => $count,
                        'role'          => 'tab',

                    ]);
                    ?>
                    <div <?php $this->print_render_attribute_string($item_title_setting_key); ?>>

                            <div class="careers-content-wrap">
                                <div class="careers-content-header">
                                    <?php if ($careersshowcase['careersshowcase_time']) { ?>
                                        <div class="careers-time"><span><?php echo esc_html($careersshowcase['careersshowcase_time']); ?></span></div>
                                    <?php } ?>
                                    <?php
                                    echo '<h6 class="careers-title">' . esc_html($careersshowcase['careersshowcase_title']) . '</h6>';
                                    ?>
                                    <?php if ($careersshowcase['careersshowcase_location']) { ?>
                                        <div class="careers-location"><i class="spaciaz-icon-marker"></i><?php echo esc_html($careersshowcase['careersshowcase_location']); ?></div>
                                    <?php } ?>
                                </div>
                                <div class="popup-icon"><i class="spaciaz-icon-plus-1"></i> </div>
                            </div>

                    </div>
                <?php endforeach; ?>

                <?php foreach ($settings['careersshowcase'] as $index => $careersshowcase): ?>

                    <?php
                    ob_start();
                    ?>
                    <div class="swiper-slide">
                        <div class="careers-slide">

                            <?php
                            echo '<h2 class="careers-title">' . esc_html($careersshowcase['careersshowcase_title']) . '</h2>';
                            ?>

                            <div class="careers-content">
                                <?php if ($careersshowcase['careersshowcase_description']) { ?>
                                    <div class="careers-description"><?php echo wp_kses_post($careersshowcase['careersshowcase_description']); ?></div>
                                <?php } ?>

                                <div class="careers-infor-wrap elementor-button-outline">
                                    <div class="careers-infor">
                                        <?php if ($careersshowcase['careersshowcase_time']) { ?>
                                            <div class="careers-time"><i class="spaciaz-icon-calendar"></i><?php echo esc_html($careersshowcase['careersshowcase_time']); ?></div>
                                        <?php } ?>

                                        <?php if ($careersshowcase['careersshowcase_hours']) { ?>
                                            <div class="careers-hours"><i class="spaciaz-icon-clock"></i><?php echo esc_html($careersshowcase['careersshowcase_hours']); ?></div>
                                        <?php } ?>

                                        <?php if ($careersshowcase['careersshowcase_location']) { ?>
                                            <div class="careers-location"><i class="spaciaz-icon-marker-pin"></i><?php echo esc_html($careersshowcase['careersshowcase_location']); ?></div>
                                        <?php } ?>
                                    </div>


                                    <?php if (!empty($careersshowcase['careersshowcase_link']['url'])) : ?>
                                        <a class="careers-button elementor-button" href="<?php echo esc_url($careersshowcase['careersshowcase_link']['url']); ?>">
                                            <span class="elementor-button-content-wrapper">
                                                <span class="elementor-button-text"><?php echo esc_html($careersshowcase['careersshowcase_textlink']); ?></span>
                                                <span class="elementor-button-icon">
                                                    <span class="btn-icon-wrap">
                                                        <span class="btn-icon"><i class="spaciaz-icon-arrow-long-right"></i></span>
                                                        <span class="btn-icon-hover"><i class="spaciaz-icon-arrow-long-right"></i></span>
                                                    </span>
                                                </span>
                                            </span>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>
                    </div>
                    <?php
                    $slide_html .= ob_get_clean();
                endforeach; ?>
            </div>

            <div class="careers-popup mfp-hide" id="<?php echo esc_attr('careers-popup-' . $this->get_id()); ?>">
                <div class="careers-popup-inner">
                    <button class="careers-popup-close mfp-close">
                        <svg class="close-icon" xmlns="http://www.w3.org/2000/svg" width="23.691" height="22.723" viewBox="0 0 23.691 22.723">
                            <g transform="translate(-126.154 -143.139)">
                                <line x2="23" y2="22" transform="translate(126.5 143.5)" fill="none" stroke="CurrentColor" stroke-width="5"></line>
                                <path d="M0,22,23,0" transform="translate(126.5 143.5)" fill="none" stroke="CurrentColor" stroke-width="5"></path>
                            </g>
                        </svg>
                    </button>
                    <div class="spaciaz-swiper-wrap">
                        <div class="spaciaz-swiper swiper swiper-careers-popup">
                            <div class="swiper-wrapper">
                                <?php printf('%s', $slide_html); ?>
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

$widgets_manager->register(new Spaciaz_Elementor_Careers_Showcase());
