<?php
// nested-tabs
use Elementor\Controls_Manager;

add_action('elementor/element/nested-tabs/section_tabs/before_section_end', function ($element, $args) {
    /** @var \Elementor\Element_Base $element */
    $element->add_control(
        'tabs_style',
        [
            'label'        => esc_html__('Style', 'spaciaz'),
            'type'         => Controls_Manager::SELECT,
            'default'      => 'default',
            'options'      => [
                'default' => esc_html__('Style default', 'spaciaz'),
                '1' => esc_html__('Style 1', 'spaciaz'),
            ],
            'prefix_class' => 'elementor-tabs-style-',
        ]
    );
}, 10, 2);

add_action( 'elementor/element/nested-tabs/section_tabs_style/before_section_end', function ( $element, $args ) {

    $element->add_responsive_control(
        'margin',
        [
            'label' => esc_html__( 'Margin', 'spaciaz' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
            'selectors' => [
                '{{WRAPPER}}.elementor-widget-n-tabs .e-n-tabs-heading' => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};",
            ],
        ]
    );

}, 10, 2 );
