<?php

use Elementor\Controls_Manager;

add_action('elementor/element/icon/section_style_icon/before_section_end', function ($element, $args) {
    $element->add_control(
        'show_icon_effect',
        [
            'label'        => esc_html__('Show Icon Effect', 'spaciaz'),
            'type'         => Controls_Manager::SWITCHER,
            'condition' => [
                'selected_icon[value]!' => '',
            ],
            'prefix_class' => 'effect-icon-',
        ]
    );

}, 10, 2);

add_action('elementor/element/icon-box/section_style_box/before_section_end', function ($element, $args) {
    $element->add_control(
        'show_divider',
        [
            'label'        => esc_html__('Divider', 'spaciaz'),
            'type'         => Controls_Manager::SWITCHER,
            'condition' => [
                'selected_icon[value]!' => '',
            ],
            'prefix_class' => 'show-divider-',
        ]
    );

    $element->add_control(
        'divider_color',
        [
            'label'        => esc_html__('Divider Color', 'spaciaz'),
            'type'         => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}}.show-divider-yes .elementor-icon-box-icon:before' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.show-divider-yes .elementor-icon-box-icon:after' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'show_divider!' => '',
            ],
        ]
    );

    $element->add_control(
        'divider_color_hover',
        [
            'label'        => esc_html__('Divider Color Hover', 'spaciaz'),
            'type'         => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}}.show-divider-yes:hover .elementor-icon-box-icon:before' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.show-divider-yes:hover .elementor-icon-box-icon:after' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'show_divider!' => '',
            ],
        ]
    );

}, 10, 2);
