<?php
// Icon List
use Elementor\Controls_Manager;
add_action( 'elementor/element/icon-list/section_icon/before_section_end', function ( $element, $args ) {
    $element->add_control(
        'icon_style_theme',
        [
            'label' => esc_html__('Theme Style', 'spaciaz'),
            'type' => Controls_Manager::SWITCHER,
            'default' => '',
            'prefix_class' => 'icon-list-style-spaciaz-',
        ]
    );

    $element->add_control(
        'icon_style_underline_color',
        [
            'label'     => esc_html__('Color Line', 'spaciaz'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .elementor-icon-list-text' => 'background-image: linear-gradient(to right, {{VALUE}} 0%, {{VALUE}} 100%);',
            ],
            'condition' => [
                'icon_style_theme' => 'yes',
            ],
        ]
    );

}, 10, 2 );