<?php
// Button
use Elementor\Controls_Manager;

add_action('elementor/element/icon-box/section_style_icon/after_section_end', function ($element, $args) {
    /** @var \Elementor\Element_Base $element */
    $element->update_control(
        'hover_primary_color',
        [
            'label' => esc_html__( 'Primary Color', 'spaciaz' ),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}}.elementor-view-stacked:hover .elementor-icon' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.elementor-view-framed:hover .elementor-icon, {{WRAPPER}}.elementor-view-default:hover .elementor-icon' => 'fill: {{VALUE}}; color: {{VALUE}};',
            ],

        ]
    );

    $element->update_control(
        'hover_secondary_color',
        [
            'label' => esc_html__( 'Secondary Color', 'spaciaz' ),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'condition' => [
                'view!' => 'default',
            ],
            'selectors' => [
                '{{WRAPPER}}.elementor-view-framed:hover .elementor-icon' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.elementor-view-stacked:hover .elementor-icon' => 'fill: {{VALUE}}; color: {{VALUE}};',
            ],

        ]
    );

}, 10, 2);

add_action( 'elementor/element/icon-box/section_style_icon/before_section_end', function ( $element, $args ) {
    $element->add_control(
        'border_color',
        [
            'label' => esc_html__( 'Border Color', 'spaciaz' ),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'border-color: {{VALUE}};',
                '{{WRAPPER}}.elementor-view-framed .elementor-icon, {{WRAPPER}}.elementor-view-default .elementor-icon' => 'border-color: {{VALUE}};',
            ],

        ]
    );

    $element->add_control(
        'hover_border_color',
        [
            'label' => esc_html__( 'Border Color Hover', 'spaciaz' ),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'condition' => [
                'view!' => 'default',
            ],
            'selectors' => [
                '{{WRAPPER}}.elementor-view-framed:hover .elementor-icon' => 'border-color: {{VALUE}};',
                '{{WRAPPER}}.elementor-view-stacked:hover .elementor-icon' => 'border-color: {{VALUE}};',
            ],

        ]
    );

}, 10, 2 );