<?php
// Button
use Elementor\Controls_Manager;

add_action('elementor/element/button/section_button/before_section_end', function ($element, $args) {

    $element->update_control(
        'button_type',
        [
            'label' => esc_html__( 'Type', 'spaciaz' ),
            'type' => Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                '' => esc_html__( 'Default', 'spaciaz' ),
                'outline' => esc_html__( 'Outline', 'spaciaz' ),
                'link' => esc_html__( 'Link', 'spaciaz' ),
                'info' => esc_html__( 'Info', 'spaciaz' ),
                'success' => esc_html__( 'Success', 'spaciaz' ),
                'warning' => esc_html__( 'Warning', 'spaciaz' ),
                'danger' => esc_html__( 'Danger', 'spaciaz' ),
            ],
            'prefix_class' => 'elementor-button-',
        ]
    );

    $element->add_control(
        'icon_size',
        [
            'label' => esc_html__('Icon Size', 'spaciaz'),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'max' => 50,
                ],
            ],
            'condition' => [
                'selected_icon[value]!' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button .elementor-button-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .elementor-button .elementor-button-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
            ],
        ]
    );

    $element->add_control(
        'icon_color',
        [
            'label' => esc_html__( 'Icon Color', 'spaciaz' ),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .elementor-button i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .elementor-button svg' => 'fill: {{VALUE}};',
            ],
        ]
    );

    $element->add_control(
        'icon_color_hover',
        [
            'label' => esc_html__( 'Icon Color Hover', 'spaciaz' ),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .elementor-button:hover i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .elementor-button:hover svg' => 'fill: {{VALUE}};',
            ],
        ]
    );

    $element->add_control(
        'icon_bg',
        [
            'label' => esc_html__( 'Background Icon', 'spaciaz' ),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .elementor-button .elementor-button-icon' => 'background-color: {{VALUE}};',
            ],
        ]
    );

    $element->add_control(
        'line_effect',
        [
            'label' => esc_html__('Line Effect', 'spaciaz'),
            'type' => Controls_Manager::SWITCHER,
            'prefix_class' => 'line-effect-',
            'condition' => [
                'button_type' => 'link',
            ]
        ]
    );

}, 10, 2);

add_action('elementor/element/button/section_style/after_section_end', function ($element, $args) {
    /** @var \Elementor\Element_Base $element */
    $element->update_control(
        'background_color',
        [
            'global' => [
                'default' => '',
            ],
            'selectors' => [
                '{{WRAPPER}}.elementor-widget-button .elementor-button' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.elementor-widget-button.enable-button-effect-yes .elementor-button:before' => 'background-color: {{VALUE}};',
            ],

        ]
    );

    $element->update_control(
        'button_background_hover_color',
        [
            'global' => [
                'default' => '',
            ],
            'selectors' => [
                '{{WRAPPER}}.elementor-widget-button .elementor-button:hover' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.elementor-widget-button .elementor-button:hover:before' => 'background-color: {{VALUE}};',
            ],

        ]
    );

    $element->update_control(
        'button_text_color',
        [
            'global' => [
                'default' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button' => 'color: {{VALUE}};',
            ],
        ]
    );

    $element->update_control(
        'hover_color',
        [
            'global' => [
                'default' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button:hover, {{WRAPPER}} .elementor-button:focus' => 'color: {{VALUE}};',
            ],
        ]
    );

    $element->update_control(
        'button_hover_border_color',
        [
            'label' => esc_html__( 'Border Color', 'spaciaz' ),
            'type' => Controls_Manager::COLOR,
            'condition' => [
                'border_border!' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button:hover, {{WRAPPER}} .elementor-button:focus' => 'border-color: {{VALUE}};',
                '{{WRAPPER}}.enable-button-effect-yes .elementor-button:hover:before' => 'border-color: {{VALUE}};',
            ],
        ]
    );

    $element->update_responsive_control(
        'border_radius',
        [
            'label' => esc_html__( 'Border Radius', 'spaciaz' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                '{{WRAPPER}}.enable-button-effect-yes .elementor-button:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );

}, 10, 2);


