<?php

use Elementor\Plugin;

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Spaciaz_Elementor')) :

    /**
     * The Spaciaz Elementor Integration class
     */
    class Spaciaz_Elementor {
        private $suffix = '';

        public function __construct() {
            $this->suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';

            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'register_auto_scripts_frontend']);
            add_action('elementor/elements/categories_registered', [$this, 'register_widget_category']);
            add_action('wp_enqueue_scripts', [$this, 'add_scripts'], 15);
            add_action('wp_enqueue_scripts', [$this, 'add_styles'], 9);
            add_action('elementor/widgets/register', array($this, 'customs_widgets'));
            add_action('elementor/widgets/register', array($this, 'include_widgets'));
            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'add_js']);

            // Custom Animation Scroll
            add_filter('elementor/controls/animations/additional_animations', [$this, 'add_animations_scroll']);
            // Backend
            add_action('elementor/editor/after_enqueue_styles', [$this, 'add_style_editor'], 99);

            // Add Icon Custom
            add_action('elementor/icons_manager/native', [$this, 'add_icons_native']);
            add_action('elementor/controls/controls_registered', [$this, 'add_icons']);

            if (!spaciaz_is_elementor_pro_activated()) {
                require get_theme_file_path( 'inc/elementor/custom-css.php');
                require get_theme_file_path( 'inc/elementor/sticky-section.php');
                if (is_admin()) {
                    add_action('manage_elementor_library_posts_columns', [$this, 'admin_columns_headers']);
                    add_action('manage_elementor_library_posts_custom_column', [$this, 'admin_columns_content'], 10, 2);
                }
                require get_theme_file_path('inc/elementor/motion-fx/controls-group.php');
                require get_theme_file_path('inc/elementor/motion-fx/module.php');
            }

            require get_theme_file_path('inc/elementor/modules/page-settings.php');
            if (function_exists('hfe_init')) {
                require get_theme_file_path('inc/elementor/modules/header-settings.php');
            }

            add_filter('elementor/fonts/additional_fonts', [$this, 'additional_fonts']);
            add_action('wp_enqueue_scripts', [$this, 'elementor_kit']);
        }

        public function elementor_kit() {
            $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
            Elementor\Plugin::$instance->kits_manager->frontend_before_enqueue_styles();
            $myvals = get_post_meta($active_kit_id, '_elementor_page_settings', true);
            if (!empty($myvals)) {
                $css = '';
                foreach ($myvals['system_colors'] as $key => $value) {
                    $css .= $value['color'] !== '' ? '--' . $value['_id'] . ':' . $value['color'] . ';' : '';
                }

                $var = "body{{$css}}";
                wp_add_inline_style('spaciaz-style', $var);
            }
        }

        public function additional_fonts($fonts) {
            $fonts['Switzer'] = 'system';
            $fonts['Involve'] = 'system';
            return $fonts;
        }

        public function admin_columns_headers($defaults) {
            $defaults['shortcode'] = esc_html__('Shortcode', 'spaciaz');

            return $defaults;
        }

        public function admin_columns_content($column_name, $post_id) {
            if ('shortcode' === $column_name) {
                ob_start();
                ?>
                <input class="elementor-shortcode-input" type="text" readonly onfocus="this.select()" value="[hfe_template id='<?php echo esc_attr($post_id); ?>']"/>
                <?php
                ob_get_contents();
            }
        }

        public function add_js() {

            wp_enqueue_script('spaciaz-elementor-frontend', get_theme_file_uri('/assets/js/elementor-frontend.js'), [], SPACIAZ_VERSION);
        }

        public function add_style_editor() {

            wp_enqueue_style('spaciaz-elementor-editor-icon', get_theme_file_uri('/assets/css/admin/elementor/icons.css'), [], SPACIAZ_VERSION);
        }

        public function add_styles() {
            wp_enqueue_style('e-swiper');
        }

        public function add_scripts() {

            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            wp_enqueue_style('spaciaz-elementor', get_template_directory_uri() . '/assets/css/base/elementor.css', '', SPACIAZ_VERSION);
            wp_style_add_data('spaciaz-elementor', 'rtl', 'replace');

            // Add Scripts

            $e_swiper_latest     = Plugin::$instance->experiments->is_feature_active('e_swiper_latest');
            $e_swiper_asset_path = $e_swiper_latest ? 'assets/lib/swiper/v8/' : 'assets/lib/swiper/';
            $e_swiper_version    = $e_swiper_latest ? '8.4.5' : '5.3.6';
            wp_register_script(
                'swiper',
                plugins_url('elementor/' . $e_swiper_asset_path . 'swiper.js', 'elementor'),
                [],
                $e_swiper_version,
                true
            );
        }

        public function register_auto_scripts_frontend() {
            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            wp_register_script('spaciaz-elementor-swiper', get_theme_file_uri('/assets/js/elementor-swiper' . $suffix . '.js'), array('jquery', 'elementor-frontend'), SPACIAZ_VERSION, true);
            // Register auto scripts frontend

            $files  = glob(get_theme_file_path('/assets/js/elementor/*' . $suffix . '.js'));
            foreach ($files as $file) {
                $file_name = wp_basename($file);
                $handle    = str_replace($suffix.".js", '', $file_name);
                $scr       = get_theme_file_uri('/assets/js/elementor/' . $file_name);
                if (file_exists($file)) {
                    wp_register_script('spaciaz-elementor-' . $handle, $scr, ['jquery', 'elementor-frontend'], SPACIAZ_VERSION, true);
                }
            }
        }

        public function register_widget_category($this_cat) {
            $this_cat->add_category(
                'spaciaz-addons',
                [
                    'title' => esc_html__('Spaciaz Addons', 'spaciaz'),
                    'icon'  => 'fa fa-plug',
                ]
            );
            return $this_cat;
        }

        public function add_animations_scroll($animations) {
            $animations['Spaciaz Animation'] = [
                'opal-move-up'    => 'Move Up',
                'opal-move-down'  => 'Move Down',
                'opal-move-left'  => 'Move Left',
                'opal-move-right' => 'Move Right',
                'opal-flip'       => 'Flip',
                'opal-helix'      => 'Helix',
                'opal-scale-up'   => 'Scale',
                'opal-am-popup'   => 'Popup',
            ];

            return $animations;
        }

        public function customs_widgets() {
            $files = glob(get_theme_file_path('/inc/elementor/custom-widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }
        }

        /**
         * @param $widgets_manager Elementor\Widgets_Manager
         */
        public function include_widgets($widgets_manager) {
            require 'base-swiper-widget.php';
            $files = glob(get_theme_file_path('/inc/elementor/widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }
        }

        public function add_icons( $manager ) {
            $new_icons = json_decode( '{"spaciaz-icon-3d-cube":"3d-cube","spaciaz-icon-arrow-long-right":"arrow-long-right","spaciaz-icon-award":"award","spaciaz-icon-building-1":"building-1","spaciaz-icon-building":"building","spaciaz-icon-buliding-2":"buliding-2","spaciaz-icon-calendar-2":"calendar-2","spaciaz-icon-calendar":"calendar","spaciaz-icon-call-out":"call-out","spaciaz-icon-check-circle":"check-circle","spaciaz-icon-chevron-down":"chevron-down","spaciaz-icon-chevron-left":"chevron-left","spaciaz-icon-chevron-right":"chevron-right","spaciaz-icon-chevron-up":"chevron-up","spaciaz-icon-clock":"clock","spaciaz-icon-diamond":"diamond","spaciaz-icon-dollar-circle":"dollar-circle","spaciaz-icon-envelope-open":"envelope-open","spaciaz-icon-expand-1":"expand-1","spaciaz-icon-extrathin-right":"extrathin-right","spaciaz-icon-face-content":"face-content","spaciaz-icon-fingerprint":"fingerprint","spaciaz-icon-firefighting":"firefighting","spaciaz-icon-format-square":"format-square","spaciaz-icon-gallery":"gallery","spaciaz-icon-guard":"guard","spaciaz-icon-layer-2":"layer-2","spaciaz-icon-layer":"layer","spaciaz-icon-like":"like","spaciaz-icon-maintenance":"maintenance","spaciaz-icon-marker-pin":"marker-pin","spaciaz-icon-marker":"marker","spaciaz-icon-medal-star":"medal-star","spaciaz-icon-messages-1":"messages-1","spaciaz-icon-people":"people","spaciaz-icon-picture-frame":"picture-frame","spaciaz-icon-plus-1":"plus-1","spaciaz-icon-question":"question","spaciaz-icon-questions":"questions","spaciaz-icon-quote-1":"quote-1","spaciaz-icon-quote":"quote","spaciaz-icon-rocket":"rocket","spaciaz-icon-ruler-pen":"ruler-pen","spaciaz-icon-security":"security","spaciaz-icon-share":"share","spaciaz-icon-shield-tick":"shield-tick","spaciaz-icon-sms-tracking":"sms-tracking","spaciaz-icon-star-1":"star-1","spaciaz-icon-sun-setting":"sun-setting","spaciaz-icon-swimming-pool":"swimming-pool","spaciaz-icon-system":"system","spaciaz-icon-target":"target","spaciaz-icon-tree":"tree","spaciaz-icon-trophy":"trophy","spaciaz-icon-users":"users","spaciaz-icon-video-play":"video-play","spaciaz-icon-wallet-check":"wallet-check","spaciaz-icon-weight":"weight","spaciaz-icon-360":"360","spaciaz-icon-arrow-down":"arrow-down","spaciaz-icon-arrow-left":"arrow-left","spaciaz-icon-arrow-right":"arrow-right","spaciaz-icon-arrow-up":"arrow-up","spaciaz-icon-arrows-rotate":"arrows-rotate","spaciaz-icon-bars":"bars","spaciaz-icon-cart-empty":"cart-empty","spaciaz-icon-check-square":"check-square","spaciaz-icon-checked":"checked","spaciaz-icon-circle":"circle","spaciaz-icon-cloud-download-alt":"cloud-download-alt","spaciaz-icon-comment":"comment","spaciaz-icon-comments":"comments","spaciaz-icon-contact":"contact","spaciaz-icon-credit-card":"credit-card","spaciaz-icon-dot-circle":"dot-circle","spaciaz-icon-edit":"edit","spaciaz-icon-envelope":"envelope","spaciaz-icon-expand-alt":"expand-alt","spaciaz-icon-expand":"expand","spaciaz-icon-external-link-alt":"external-link-alt","spaciaz-icon-file-alt":"file-alt","spaciaz-icon-file-archive":"file-archive","spaciaz-icon-folder-open":"folder-open","spaciaz-icon-folder":"folder","spaciaz-icon-frown":"frown","spaciaz-icon-gift":"gift","spaciaz-icon-grid":"grid","spaciaz-icon-grip-horizontal":"grip-horizontal","spaciaz-icon-heart-fill":"heart-fill","spaciaz-icon-heart":"heart","spaciaz-icon-history":"history","spaciaz-icon-home":"home","spaciaz-icon-info-circle":"info-circle","spaciaz-icon-instagram":"instagram","spaciaz-icon-level-up-alt":"level-up-alt","spaciaz-icon-list":"list","spaciaz-icon-map-marker-check":"map-marker-check","spaciaz-icon-meh":"meh","spaciaz-icon-minus-circle":"minus-circle","spaciaz-icon-minus":"minus","spaciaz-icon-mobile-android-alt":"mobile-android-alt","spaciaz-icon-money-bill":"money-bill","spaciaz-icon-office":"office","spaciaz-icon-pencil-alt":"pencil-alt","spaciaz-icon-phone":"phone","spaciaz-icon-plus":"plus","spaciaz-icon-random":"random","spaciaz-icon-reply-all":"reply-all","spaciaz-icon-reply":"reply","spaciaz-icon-search":"search","spaciaz-icon-shield-check":"shield-check","spaciaz-icon-shopping-basket":"shopping-basket","spaciaz-icon-sign-out-alt":"sign-out-alt","spaciaz-icon-smile":"smile","spaciaz-icon-spinner":"spinner","spaciaz-icon-square":"square","spaciaz-icon-star":"star","spaciaz-icon-sync":"sync","spaciaz-icon-tachometer-alt":"tachometer-alt","spaciaz-icon-thumbtack":"thumbtack","spaciaz-icon-times-circle":"times-circle","spaciaz-icon-times-square":"times-square","spaciaz-icon-times":"times","spaciaz-icon-trophy-alt":"trophy-alt","spaciaz-icon-adobe":"adobe","spaciaz-icon-amazon":"amazon","spaciaz-icon-android":"android","spaciaz-icon-angular":"angular","spaciaz-icon-apper":"apper","spaciaz-icon-apple":"apple","spaciaz-icon-atlassian":"atlassian","spaciaz-icon-behance":"behance","spaciaz-icon-bitbucket":"bitbucket","spaciaz-icon-bitcoin":"bitcoin","spaciaz-icon-bity":"bity","spaciaz-icon-bluetooth":"bluetooth","spaciaz-icon-btc":"btc","spaciaz-icon-centos":"centos","spaciaz-icon-chrome":"chrome","spaciaz-icon-codepen":"codepen","spaciaz-icon-cpanel":"cpanel","spaciaz-icon-discord":"discord","spaciaz-icon-dochub":"dochub","spaciaz-icon-docker":"docker","spaciaz-icon-dribbble":"dribbble","spaciaz-icon-dropbox":"dropbox","spaciaz-icon-drupal":"drupal","spaciaz-icon-ebay":"ebay","spaciaz-icon-facebook-c":"facebook-c","spaciaz-icon-facebook-f":"facebook-f","spaciaz-icon-facebook":"facebook","spaciaz-icon-figma":"figma","spaciaz-icon-firefox":"firefox","spaciaz-icon-google-plus":"google-plus","spaciaz-icon-google":"google","spaciaz-icon-grunt":"grunt","spaciaz-icon-gulp":"gulp","spaciaz-icon-html5":"html5","spaciaz-icon-ios":"ios","spaciaz-icon-joomla":"joomla","spaciaz-icon-link-brand":"link-brand","spaciaz-icon-linkedin":"linkedin","spaciaz-icon-mailchimp":"mailchimp","spaciaz-icon-nintendo-switch":"nintendo-switch","spaciaz-icon-opencart":"opencart","spaciaz-icon-paypal":"paypal","spaciaz-icon-pinterest-p":"pinterest-p","spaciaz-icon-playstation":"playstation","spaciaz-icon-reddit":"reddit","spaciaz-icon-skype":"skype","spaciaz-icon-slack":"slack","spaciaz-icon-snapchat":"snapchat","spaciaz-icon-spotify":"spotify","spaciaz-icon-steam":"steam","spaciaz-icon-trello":"trello","spaciaz-icon-twitter-x":"twitter-x","spaciaz-icon-twitter":"twitter","spaciaz-icon-vimeo":"vimeo","spaciaz-icon-whatsapp":"whatsapp","spaciaz-icon-wordpress":"wordpress","spaciaz-icon-xbox":"xbox","spaciaz-icon-yoast":"yoast","spaciaz-icon-youtube":"youtube"}', true );
			$icons     = $manager->get_control( 'icon' )->get_settings( 'options' );
			$new_icons = array_merge(
				$new_icons,
				$icons
			);
			// Then we set a new list of icons as the options of the icon control
			$manager->get_control( 'icon' )->set_settings( 'options', $new_icons ); 
        }

        public function add_icons_native($tabs) {

            $tabs['opal-custom'] = [
                'name'          => 'spaciaz-icon',
                'label'         => esc_html__('Spaciaz Icon', 'spaciaz'),
                'prefix'        => 'spaciaz-icon-',
                'displayPrefix' => 'spaciaz-icon-',
                'labelIcon'     => 'fab fa-font-awesome-alt',
                'ver'           => SPACIAZ_VERSION,
                'fetchJson'     => get_theme_file_uri('/inc/elementor/icons.json'),
                'native'        => true,
            ];

            return $tabs;
        }
    }

endif;

return new Spaciaz_Elementor();
