<?php

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;
use Elementor\Element_Base;

if (!class_exists('Spaciaz_Elementor_Section_Decor')) :
    class Spaciaz_Elementor_Section_Decor
    {
        public function __construct()
        {

            add_action('elementor/element/common/_section_responsive/after_section_end', [$this, 'register_controls']);
            add_action('elementor/element/section/_section_responsive/after_section_end', [$this, 'register_controls']);
            add_action('elementor/element/container/_section_responsive/after_section_end', [$this, 'register_controls']);
            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'enqueue_scripts']);
        }

        public function enqueue_scripts()
        {
            wp_enqueue_script('spaciaz-background-shape', get_theme_file_uri('inc/elementor/background-shape/background-shape.js'), ['jquery'], SPACIAZ_VERSION);
        }

        /**
         * @param $element \Elementor\Controls_Stack
         * @param $section_id
         * @param $args
         */
        public function register_controls(Element_Base $element)
        {

            $element->start_controls_section(
                'section_spaciaz_decor',
                [
                    'label' => esc_html__('Spaciaz Backgroud Shape', 'spaciaz'),
                    'tab' => Controls_Manager::TAB_ADVANCED,
                ]
            );

            $positions = ['top-left', 'top-right', 'bottom-right', 'bottom-left'];

            foreach ($positions as $position) {
                $enable_control = 'spaciaz_decor_' . str_replace('-', '_', $position);
                $element->add_control(
                    $enable_control,
                    [
                        'label' => sprintf(esc_html__('Enable %s', 'spaciaz'), ucfirst(str_replace('-', ' ', $position))),
                        'type' => Controls_Manager::SWITCHER,
                        'frontend_available' => true,
                    ]
                );

                $axis_controls = [
                    'vertical' => [
                        'property' => ($position === 'bottom-left' || $position === 'bottom-right') ? 'bottom' : 'top',
                    ],
                    'horizontal' => [
                        'property' => ($position === 'top-right' || $position === 'bottom-right')
                            ? (is_rtl() ? 'left' : 'right')
                            : (is_rtl() ? 'right' : 'left'),
                    ],
                ];

                foreach ($axis_controls as $axis => $data) {
                    $element->add_responsive_control(
                        "spaciaz_decor_{$position}_{$axis}",
                        [
                            'label' => sprintf(
                                esc_html__('%s', 'spaciaz'),
                                ucfirst($axis)
                            ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => ['px' => ['min' => 0, 'max' => 30]],
                            'size_units' => ['px'],
                            'selectors' => [
                                "{{WRAPPER}} .spaciaz-border-shape.{$position}" => "{$data['property']}: {{SIZE}}{{UNIT}};",
                            ],
                            'condition' => [$enable_control => 'yes'],
                        ]
                    );
                }

                $element->add_responsive_control(
                    "spaciaz_decor_{$position}_rotate",
                    [
                        'label' => esc_html__('Rotate', 'spaciaz'),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => ['deg', 'grad', 'rad', 'turn', 'custom'],
                        'default' => ['unit' => 'deg'],
                        'tablet_default' => ['unit' => 'deg'],
                        'mobile_default' => ['unit' => 'deg'],
                        'selectors' => [
                            "{{WRAPPER}} .spaciaz-border-shape.{$position}" => "transform: rotate({{SIZE}}{{UNIT}});",
                        ],
                        'condition' => [$enable_control => 'yes'],
                    ]
                );
            }

            $element->add_control('spaciaz_decor_color',
                [
                    'label' => esc_html__('Background Color', 'spaciaz'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .spaciaz-border-shape' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $element->add_responsive_control(
                'spaciaz_decor_size',
                [
                    'label' => esc_html__('Size', 'spaciaz'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 30
                    ],
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .spaciaz-border-shape' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};clip-path:path("M0 0 Q0,{{SIZE}} {{SIZE}},{{SIZE}} L 0 {{SIZE}} Z");',
                    ],
                ]
            );
            $element->end_controls_section();
        }
    }
endif;

return new Spaciaz_Elementor_Section_Decor();
