<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Spaciaz_Customize')) {

    class Spaciaz_Customize {


        public function __construct() {
            add_action('customize_register', array($this, 'customize_register'));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         */
        public function customize_register($wp_customize) {

            /**
             * Theme options.
             */
            require_once get_theme_file_path('inc/customize-control/editor.php');
            $this->init_spaciaz_blog($wp_customize);
            $this->init_spaciaz_social($wp_customize);
            $this->init_spaciaz_scroll($wp_customize);

            do_action('spaciaz_customize_register', $wp_customize);
        }

        public function init_spaciaz_scroll($wp_customize) {

            $wp_customize->add_section('spaciaz_smooth_scroll', array(
                'title' => esc_html__('Spaciaz Settings', 'spaciaz'),
            ));

            $wp_customize->add_setting('spaciaz_options_smooth_scroll', array(
                'type'              => 'option',
                'default'           => '',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_smooth_scroll', array(
                'type'        => 'radio',
                'section'     => 'spaciaz_smooth_scroll',
                'label'       => esc_html__('Enable Smooth Scroll', 'spaciaz'),
                'description' => esc_html__('Smooth Scroll On Windows', 'spaciaz'),
                'choices'     => array(
                    ''    => esc_html__('No', 'spaciaz'),
                    'yes' => esc_html__('Yes', 'spaciaz'),
                ),
            ));

            $wp_customize->add_setting('spaciaz_options_enable_backtop', array(
                'type'              => 'option',
                'default'           => 'yes',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_enable_backtop', array(
                'type'        => 'radio',
                'section'     => 'spaciaz_smooth_scroll',
                'label'       => esc_html__('Button Back to Top', 'spaciaz'),
                'choices'     => array(
                    ''    => esc_html__('No', 'spaciaz'),
                    'yes' => esc_html__('Yes', 'spaciaz'),
                ),
            ));
        }


        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_spaciaz_blog($wp_customize) {

            $wp_customize->add_section('spaciaz_blog_archive', array(
                'title' => esc_html__('Blog', 'spaciaz'),
            ));

            // =========================================
            // Select Style
            // =========================================

            $wp_customize->add_setting('spaciaz_options_blog_style', array(
                'type'              => 'option',
                'default'           => 'standard',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_blog_style', array(
                'section' => 'spaciaz_blog_archive',
                'label'   => esc_html__('Blog style', 'spaciaz'),
                'type'    => 'select',
                'choices' => array(
                    'standard' => esc_html__('Blog Standard', 'spaciaz'),
                    //====start_premium
                    'grid'     => esc_html__('Blog Grid', 'spaciaz'),
                    'list'     => esc_html__('Blog List', 'spaciaz'),
                    //====end_premium
                ),
            ));

            $wp_customize->add_setting('spaciaz_options_blog_columns', array(
                'type'              => 'option',
                'default'           => 1,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_blog_columns', array(
                'section' => 'spaciaz_blog_archive',
                'label'   => esc_html__('Colunms', 'spaciaz'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'spaciaz'),
                    2 => esc_html__('2', 'spaciaz'),
                    3 => esc_html__('3', 'spaciaz'),
                    4 => esc_html__('4', 'spaciaz'),
                ),
            ));

            $wp_customize->add_setting('spaciaz_options_blog_archive_sidebar', array(
                'type'              => 'option',
                'default'           => 'right',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_blog_archive_sidebar', array(
                'section' => 'spaciaz_blog_archive',
                'label'   => esc_html__('Sidebar Position', 'spaciaz'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'spaciaz'),
                    'right' => esc_html__('Right', 'spaciaz'),
                ),
            ));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_spaciaz_social($wp_customize) {

            $wp_customize->add_section('spaciaz_social', array(
                'title' => esc_html__('Socials', 'spaciaz'),
            ));
            $wp_customize->add_setting('spaciaz_options_social_share', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_social_share', array(
                'type'    => 'checkbox',
                'section' => 'spaciaz_social',
                'label'   => esc_html__('Show Social Share', 'spaciaz'),
            ));
            $wp_customize->add_setting('spaciaz_options_social_share_facebook', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_social_share_facebook', array(
                'type'    => 'checkbox',
                'section' => 'spaciaz_social',
                'label'   => esc_html__('Share on Facebook', 'spaciaz'),
            ));
            $wp_customize->add_setting('spaciaz_options_social_share_twitter', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_social_share_twitter', array(
                'type'    => 'checkbox',
                'section' => 'spaciaz_social',
                'label'   => esc_html__('Share on Twitter', 'spaciaz'),
            ));
            $wp_customize->add_setting('spaciaz_options_social_share_linkedin', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_social_share_linkedin', array(
                'type'    => 'checkbox',
                'section' => 'spaciaz_social',
                'label'   => esc_html__('Share on Linkedin', 'spaciaz'),
            ));
            $wp_customize->add_setting('spaciaz_options_social_share_google-plus', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_social_share_google-plus', array(
                'type'    => 'checkbox',
                'section' => 'spaciaz_social',
                'label'   => esc_html__('Share on Google+', 'spaciaz'),
            ));

            $wp_customize->add_setting('spaciaz_options_social_share_pinterest', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_social_share_pinterest', array(
                'type'    => 'checkbox',
                'section' => 'spaciaz_social',
                'label'   => esc_html__('Share on Pinterest', 'spaciaz'),
            ));
            $wp_customize->add_setting('spaciaz_options_social_share_email', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('spaciaz_options_social_share_email', array(
                'type'    => 'checkbox',
                'section' => 'spaciaz_social',
                'label'   => esc_html__('Share on Email', 'spaciaz'),
            ));
        }
    }
}
return new Spaciaz_Customize();
