<?php
$theme          = wp_get_theme('spaciaz');
define( 'SPACIAZ_VERSION', $theme['Version'] );
if ( ! isset( $content_width ) ) $content_width = 900;

require_once get_theme_file_path('inc/class-tgm-plugin-activation.php');
require_once get_theme_file_path('inc/class-main.php');
require_once get_theme_file_path('inc/functions.php');
require_once get_theme_file_path('inc/template-hooks.php');
require_once get_theme_file_path('inc/template-functions.php');

require_once get_theme_file_path('inc/merlin/vendor/autoload.php');
require_once get_theme_file_path('inc/merlin/class-merlin.php');
require_once get_theme_file_path('inc/merlin-config.php');
require_once get_theme_file_path('inc/class-customize.php');

if (spaciaz_is_elementor_activated()) {
    require_once get_theme_file_path('inc/elementor/functions-elementor.php');
    require_once get_theme_file_path('inc/elementor/class-elementor.php');
    require_once get_theme_file_path('inc/megamenu/megamenu.php');
    require_once get_theme_file_path('inc/elementor/section-parallax.php');
    require_once get_theme_file_path('inc/elementor/background-shape/section-decor.php');
    if (defined('ELEMENTOR_PRO_VERSION')) {
        require_once get_theme_file_path('inc/elementor/class-elementor-pro.php');
    }

    require_once get_theme_file_path('inc/elementor/elementor-control/class-elementor-control.php');

    if (function_exists('hfe_init')) {
        require_once get_theme_file_path('inc/header-footer-elementor/class-hfe.php');
        require_once get_theme_file_path('inc/merlin/includes/breadcrumb.php');
    }
    require_once get_theme_file_path('inc/merlin/includes/services.php');
    require_once get_theme_file_path('inc/merlin/includes/projects.php');
}

if (!is_user_logged_in()) {
    require_once get_theme_file_path('inc/modules/class-login.php');
}else {
    require_once get_theme_file_path('inc/modules/media-custom-field.php');
}

function spaciaz_projects_media_metabox() {

    $cmb = new_cmb2_box([
        'id'           => 'spaciaz_projects_media',
        'title'        => 'Media',
        'object_types' => ['spaciaz_project'],
        'context'      => 'normal',
        'priority'     => 'high',
    ]);

    // photos (multiple)
    $cmb->add_field([
        'name' => 'Photos',
        'id'   => 'spaciaz_photos',
        'type' => 'file_list',
    ]);

    // plans (multiple)
    $cmb->add_field([
        'name' => 'Plans',
        'id'   => 'spaciaz_plans',
        'type' => 'file_list',
    ]);

    // video (url youtube/vimeo)
    $cmb->add_field([
        'name' => 'Video URL',
        'id'   => 'spaciaz_video_url',
        'type' => 'oembed',
    ]);

    // street view (url google maps embed)
    $cmb->add_field([
        'name' => 'Street View URL',
        'id'   => 'spaciaz_street_view_url',
        'type' => 'text_url',
    ]);
}

add_action( 'cmb2_admin_init', 'spaciaz_project_location_metabox' );
function spaciaz_project_location_metabox() {

    $cmb = new_cmb2_box([
        'id'           => 'spaciaz_location_box',
        'title'        => 'Location',
        'object_types' => ['spaciaz_project'],
        'context'      => 'normal',
        'priority'     => 'high',
    ]);

    // Subtitle
    $cmb->add_field([
        'name' => 'Subtitle',
        'id'   => 'spaciaz_location_subtitle',
        'type' => 'text',
        'default' => 'Location'
    ]);

    // Title
    $cmb->add_field([
        'name' => 'Title',
        'id'   => 'spaciaz_location_title',
        'type' => 'text',
    ]);

    // Text
    $cmb->add_field([
        'name' => 'Description',
        'id'   => 'spaciaz_location_text',
        'type' => 'textarea_small',
    ]);

    // Google Maps iframe
    $cmb->add_field([
        'name' => 'Google Maps Iframe',
        'id'   => 'spaciaz_location_map_iframe',
        'type' => 'textarea_code',
        'description' => 'Cole aqui o código IFRAME completo do Google Maps.'
    ]);
}

/* --------------------------------------------------------------
   METABOX – Código do Imóvel (Projects) - FINAL SEM PREÇO
-------------------------------------------------------------- */

function baden_custom_project_fields() {

    add_meta_box(
        'project_extra_fields',
        'Informações do Imóvel',
        'baden_render_project_fields',
        'spaciaz_project', // Post type do seu tema
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'baden_custom_project_fields');

function baden_render_project_fields($post) {
    wp_nonce_field('baden_save_project_fields', 'baden_project_fields_nonce');

    $project_code   = get_post_meta($post->ID, 'project_code', true);
    ?>
    <style>
        .baden-field { margin-bottom: 18px; }
        .baden-field label { font-weight: 600; display:block; margin-bottom:6px; }
        .baden-field input[type="text"] { width:100%; padding:8px; font-size:16px; box-sizing:border-box; }
    </style>

    <div class="baden-field">
        <label for="project_code">Código do Imóvel</label>
        <input type="text" id="project_code" name="project_code"
            value="<?php echo esc_attr($project_code); ?>" maxlength="50"
            placeholder="Ex: A-2391, 10293, etc.">
    </div>

    <?php
}

function baden_save_project_fields($post_id) {

    // verifica nonce
    if ( ! isset($_POST['baden_project_fields_nonce']) || ! wp_verify_nonce($_POST['baden_project_fields_nonce'], 'baden_save_project_fields') ) {
        return;
    }

    // impede autosave
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return;

    // capacidade de edição
    if ( ! current_user_can( 'edit_post', $post_id ) ) return;

    // salva código
    if ( isset($_POST['project_code']) ) {
        $code = sanitize_text_field( $_POST['project_code'] );
        update_post_meta( $post_id, 'project_code', $code );
    }
}
add_action('save_post', 'baden_save_project_fields');

add_action('cmb2_admin_init', 'spaciaz_register_property_code_field');
function spaciaz_register_property_code_field() {
    $cmb = new_cmb2_box([
        'id'           => 'spaciaz_property_code_box',
        'title'        => 'Código do Imóvel',
        'object_types' => ['spaciaz_project'],
    ]);

    $cmb->add_field([
        'name' => 'Código do Imóvel',
        'id'   => 'spaciaz_property_code',
        'type' => 'text',
    ]);
}

/* =========================================================
 *  SWIPER (CARROSSEL)
 * ========================================================= */
function baden_enqueue_swiper_assets() {
    wp_enqueue_style(
        'swiper-css',
        'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css',
        [],
        '11.0'
    );

    wp_enqueue_script(
        'swiper-js',
        'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js',
        [],
        '11.0',
        true
    );
}
add_action('wp_enqueue_scripts', 'baden_enqueue_swiper_assets');


/* =========================================================
 *  DETECTOR SEMÂNTICO FRENTE MAR (JETIMOB)
 * ========================================================= */
function baden_is_frente_mar($text) {
    if (!is_string($text)) return false;

    $text = strtolower($text);
    $text = remove_accents($text);
    $text = str_replace(['/', '-', '_'], ' ', $text);

    return (strpos($text, 'frente') !== false && strpos($text, 'mar') !== false);
}


/* =========================================================
 *  SHORTCODE [baden_projects]
 * ========================================================= */
function baden_projects_shortcode($atts) {
    ob_start();

    $atts = shortcode_atts([
        'limit'      => 6,
        'style'      => 'style-2',
        'frente_mar' => 0,
        'carousel'   => 0,
    ], $atts);

    $limit = intval($atts['limit']);

    /* ---------- CACHE ---------- */
    $cache_key = 'baden_projects_' . md5(json_encode($atts));
    if ($cached = get_transient($cache_key)) {
        return $cached;
    }

    $posts_ids = [];

    /* ---------- 1️⃣ JÁ MARCADOS ---------- */
    if ($atts['frente_mar'] == 1) {
        $q = new WP_Query([
            'post_type'      => 'spaciaz_project',
            'posts_per_page' => $limit,
            'meta_query'     => [
                [
                    'key'   => '_frente_mar',
                    'value' => '1',
                ]
            ],
            'fields' => 'ids'
        ]);
        $posts_ids = $q->posts;
    }

    /* ---------- 2️⃣ FALLBACK JETIMOB ---------- */
    if ($atts['frente_mar'] == 1 && count($posts_ids) < $limit) {

        $fallback = new WP_Query([
            'post_type'      => 'spaciaz_project',
            'posts_per_page' => $limit * 6,
            'post__not_in'   => $posts_ids,
        ]);

        while ($fallback->have_posts() && count($posts_ids) < $limit) {
            $fallback->the_post();
            $meta = get_post_meta(get_the_ID());

            $found = false;

            foreach ($meta as $values) {
                foreach ($values as $value) {

                    $value = maybe_unserialize($value);

                    if (is_array($value)) {
                        foreach ($value as $item) {
                            if (baden_is_frente_mar($item)) {
                                $found = true;
                                break 3;
                            }
                        }
                    } else {
                        if (baden_is_frente_mar($value)) {
                            $found = true;
                            break 2;
                        }
                    }
                }
            }

            if ($found) {
                update_post_meta(get_the_ID(), '_frente_mar', 1);
                $posts_ids[] = get_the_ID();
            }
        }

        wp_reset_postdata();
    }

    /* ---------- 3️⃣ SEM FILTRO ---------- */
    if ($atts['frente_mar'] == 0) {
        $q = new WP_Query([
            'post_type'      => 'spaciaz_project',
            'posts_per_page' => $limit,
            'fields'         => 'ids'
        ]);
        $posts_ids = $q->posts;
    }

    /* ---------- 4️⃣ RENDER ---------- */
    if ($posts_ids) {

        $is_carousel = ($atts['carousel'] == 1);

        if ($is_carousel) {
            echo '<div class="baden-projects-swiper swiper">';
            echo '<div class="swiper-wrapper">';
        } else {
            echo '<div class="baden-projects-shortcode">';
            echo '<div class="d-grid grid-columns-desktop-3 grid-columns-tablet-2 grid-columns-1" style="--gutter-width:30px;">';
        }

        global $post;

        foreach ($posts_ids as $pid) {
            $post = get_post($pid);
            setup_postdata($post);

            echo $is_carousel ? '<div class="swiper-slide">' : '<div class="grid-item">';

            get_template_part(
                'template-parts/project/item-project',
                esc_attr($atts['style'])
            );

            echo '</div>';
        }

        wp_reset_postdata();

        if ($is_carousel) {
            echo '</div>';
            echo '<div class="swiper-pagination"></div>';
            echo '<div class="swiper-button-prev"></div>';
            echo '<div class="swiper-button-next"></div>';
            echo '</div>';
        } else {
            echo '</div></div>';
        }
    }

    $output = ob_get_clean();
    set_transient($cache_key, $output, 6 * HOUR_IN_SECONDS);

    return $output;
}
add_shortcode('baden_projects', 'baden_projects_shortcode');


/* =========================================================
 *  INIT SWIPER
 * ========================================================= */
function baden_init_swiper() {
?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    document.querySelectorAll('.baden-projects-swiper').forEach(function (el) {

        new Swiper(el, {
            slidesPerView: 1.2,
            spaceBetween: 24,
            watchOverflow: true,
            observer: true,
            observeParents: true,

            pagination: {
                el: el.querySelector('.swiper-pagination'),
                clickable: true,
            },

            navigation: {
                nextEl: el.querySelector('.swiper-button-next'),
                prevEl: el.querySelector('.swiper-button-prev'),
            },

            breakpoints: {
                640: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 3, // ✅ DESKTOP
                }
            }
        });

    });

});
</script>
<?php
}
add_action('wp_footer', 'baden_init_swiper', 30);


/* =========================================================
 *  SHORTCODE: IMÓVEIS EM CONSTRUÇÃO (TAXONOMIA project_status)
 *  [baden_projects_construction]
 * ========================================================= */
function baden_projects_construction_shortcode($atts) {
    ob_start();

    $atts = shortcode_atts([
        'limit'    => 6,
        'style'    => 'style-2',
        'carousel' => 0,
    ], $atts);

    $limit = intval($atts['limit']);

    /* ---------- CACHE ---------- */
    $cache_key = 'baden_projects_construction_' . md5(json_encode($atts));
    if ($cached = get_transient($cache_key)) {
        return $cached;
    }

    /* ---------- QUERY POR TAXONOMIA ---------- */
    $query = new WP_Query([
        'post_type'      => 'spaciaz_project',
        'posts_per_page' => $limit,
        'tax_query'      => [
            [
                'taxonomy' => 'project_status',
                'field'    => 'slug',
                'terms'    => ['na-planta'], // ✅ CONFIRMADO
            ]
        ],
        'fields' => 'ids',
    ]);

    $posts_ids = $query->posts;

    /* ---------- RENDER ---------- */
    if (!empty($posts_ids)) {

        $is_carousel = ($atts['carousel'] == 1);

        if ($is_carousel) {
            echo '<div class="baden-projects-swiper swiper">';
            echo '<div class="swiper-wrapper">';
        } else {
            echo '<div class="baden-projects-shortcode">';
            echo '<div class="d-grid grid-columns-desktop-3 grid-columns-tablet-2 grid-columns-1" style="--gutter-width:30px;">';
        }

        global $post;

        foreach ($posts_ids as $pid) {
            $post = get_post($pid);
            setup_postdata($post);

            echo $is_carousel
                ? '<div class="swiper-slide">'
                : '<div class="grid-item">';

            get_template_part(
                'template-parts/project/item-project',
                esc_attr($atts['style'])
            );

            echo '</div>';
        }

        wp_reset_postdata();

        if ($is_carousel) {
            echo '</div>'; // swiper-wrapper
            echo '<div class="swiper-pagination"></div>';
            echo '<div class="swiper-button-prev"></div>';
            echo '<div class="swiper-button-next"></div>';
            echo '</div>'; // swiper
        } else {
            echo '</div></div>';
        }
    }

    $output = ob_get_clean();

    /* ---------- CACHE 6H ---------- */
    set_transient($cache_key, $output, 6 * HOUR_IN_SECONDS);

    return $output;
}
add_shortcode('baden_projects_construction', 'baden_projects_construction_shortcode');




/* ==========================================
   Enviar lead para Jetimob com unidades específicas
   ========================================== */

add_action('wp_ajax_enviar_jetimob', 'baden_enviar_jetimob');
add_action('wp_ajax_nopriv_enviar_jetimob', 'baden_enviar_jetimob');

function baden_enviar_jetimob() {

    if ( empty($_POST['nonce']) || ! wp_verify_nonce($_POST['nonce'], 'jetimob_form_nonce') ) {
        wp_send_json_error("Falha de segurança.");
    }

    $nome     = sanitize_text_field($_POST['nome'] ?? '');
    $telefone = sanitize_text_field($_POST['telefone'] ?? '');
    $email    = sanitize_email($_POST['email'] ?? '');
    $codigo   = sanitize_text_field($_POST['codigo'] ?? '');
    $valor    = sanitize_text_field($_POST['valor'] ?? '');
    $mensagem = sanitize_textarea_field($_POST['mensagem'] ?? '');
    $unidade  = sanitize_text_field($_POST['unidade'] ?? '');  // Nova variável de unidade

    if (!$nome || !$telefone || !$email || !$mensagem) {
        wp_send_json_error("Preencha todos os campos obrigatórios.");
    }

    // CHAVES DO JETIMOB
    $PUBLIC_KEY  = 'qmgecwXI3ShvVNHr1dDxdxRNMeFlzRYBXR08oNeL1Ot0LWmmpsKQ3foHVVzPR5vU';
    $PRIVATE_KEY = 'SjG1wVd2U1Zowp0cq8pB6RtpWGMiwJKoFjcflQrVStDxAgl2kGGDkc0kQG1H2ZzR';

    // ENDPOINT
    $endpoint = "https://api.jetimob.com/leads/$PUBLIC_KEY";

    // URL COMPLETA
    $full_url = (isset($_SERVER['HTTPS']) ? 'https://' : 'http://')
                . $_SERVER['HTTP_HOST']
                . $_SERVER['REQUEST_URI'];

    // MULTIPART FORM-DATA – FORMATO EXATO QUE A API EXIGE
    $body = [
        // DADOS DO LEAD
        'full_name'         => $nome,
        'email'             => $email,
        'phone'             => $telefone,
        'message'           => $mensagem,

        // ORIGEM REAL
        'source'            => 'Site Baden',
        'url'               => $_SERVER['HTTP_REFERER'] ?? $full_url,
        'url_utm'           => $full_url,

        // UTM AUTOMÁTICAS
        'utm_source'        => $_GET['utm_source']  ?? '',
        'utm_medium'        => $_GET['utm_medium']  ?? '',
        'utm_campaign'      => $_GET['utm_campaign'] ?? '',
        'utm_term'          => $_GET['utm_term'] ?? '',
        'utm_content'       => $_GET['utm_content'] ?? '',

        // IDs DE CAMPANHA
        'gclid'             => $_GET['gclid'] ?? '',
        'fbclid'            => $_GET['fbclid'] ?? '',

        // ORIGEM DO PAINEL JETIMOB
        'prospecting_supply_id' => 2121350,

        // IMÓVEL
        'property_code'     => $codigo,
        'property_price'    => $valor,
        'property_contract' => 1, // venda

        // TAGS INTERNAS
        'tag'               => 'lead_site_baden',
        'unidade'          => $unidade // Envio da unidade
    ];

    $args = [
        'headers' => [
            'Authorization-Key' => $PRIVATE_KEY,
        ],
        'body'    => $body,
        'timeout' => 20,
    ];

    $response = wp_remote_post($endpoint, $args);

    if (is_wp_error($response)) {
        wp_send_json_error("Erro de conexão com o CRM.");
    }

    $code = wp_remote_retrieve_response_code($response);
    $bodyResponse = wp_remote_retrieve_body($response);

    if ($code === 200) {
        wp_send_json_success("Formulário enviado com sucesso!");
    } else {
        wp_send_json_error("Erro Jetimob: " . $bodyResponse);
    }
}


/* =========================
   METABOXE SELECT OPCAO COMPRA/VENDA
   ========================= */

function baden_project_negociacao_metabox() {

    add_meta_box(
        'project_negociacao_fields',
        'Tipo de Negociação',
        'baden_render_negociacao_fields',
        'spaciaz_project', // O CPT correto
        'side',
        'high'
    );
}
add_action('add_meta_boxes', 'baden_project_negociacao_metabox');

function baden_render_negociacao_fields($post) {

    $value = get_post_meta($post->ID, '_negociacao_tipo', true);

    wp_nonce_field('baden_negociacao_nonce_action', 'baden_negociacao_nonce');
    ?>

    <label for="negociacao_tipo"><strong>Selecione:</strong></label>
    <select name="negociacao_tipo" id="negociacao_tipo" style="width:100%;margin-top:8px;">
        <option value="">— selecione —</option>
        <option value="compra" <?php selected($value, 'compra'); ?>>Compra</option>
        <option value="locacao" <?php selected($value, 'locacao'); ?>>Locação</option>
        <option value="compra_locacao" <?php selected($value, 'compra_locacao'); ?>>Compra e Locação</option>
    </select>

    <?php
}

// SALVAR
function baden_save_negociacao_fields($post_id) {

    if (!isset($_POST['baden_negociacao_nonce']) ||
        !wp_verify_nonce($_POST['baden_negociacao_nonce'], 'baden_negociacao_nonce_action')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (isset($_POST['negociacao_tipo'])) {
        update_post_meta($post_id, '_negociacao_tipo', sanitize_text_field($_POST['negociacao_tipo']));
    }

}
add_action('save_post', 'baden_save_negociacao_fields');

// Alias /imoveis/ para o CPT spaciaz_project
add_action('init', function () {
    add_rewrite_rule(
        '^imoveis/?$',
        'index.php?post_type=spaciaz_project',
        'top'
    );
});

// Flush apenas quando alterar o código
add_action('init', function() {
    if (get_option('baden_flush_rewrite_imoveis') != 'yes') {
        flush_rewrite_rules();
        update_option('baden_flush_rewrite_imoveis', 'yes');
    }
});



/* =========================================================
 *  SHORTCODE: BUSCA DE IMÓVEIS (HOME)
 *  [baden_search]
 * ========================================================= */
function baden_search_shortcode() {
    ob_start();

    $locations = get_terms(['taxonomy' => 'project_location', 'hide_empty' => false]);
    $types     = get_terms(['taxonomy' => 'project_type', 'hide_empty' => false]);
    $status    = get_terms(['taxonomy' => 'project_status', 'hide_empty' => false]);
    $budgets   = get_terms(['taxonomy' => 'project_budget', 'hide_empty' => false]);

    $action_url = get_post_type_archive_link('spaciaz_project');
    ?>

    <form class="baden-search-form" method="get" action="<?php echo esc_url($action_url); ?>">

        <div class="baden-search-tabs">
      <button type="button" class="baden-tab active" data-value="buy">Comprar</button>
            <button type="button" class="baden-tab" data-value="rent">Alugar</button>
            <input type="hidden" name="negocio" value="buy">
        </div>

        <div class="baden-search-fields">

            <select name="location">
                <option value="">Localização</option>
                <?php foreach ($locations as $term): ?>
                    <option value="<?php echo esc_attr($term->slug); ?>"><?php echo esc_html($term->name); ?></option>
                <?php endforeach; ?>
            </select>

            <select name="type">
                <option value="">Tipo do imóvel</option>
                <?php foreach ($types as $term): ?>
                    <option value="<?php echo esc_attr($term->slug); ?>"><?php echo esc_html($term->name); ?></option>
                <?php endforeach; ?>
            </select>

            <select name="status">
                <option value="">Status do imóvel</option>
                <?php foreach ($status as $term): ?>
                    <option value="<?php echo esc_attr($term->slug); ?>"><?php echo esc_html($term->name); ?></option>
                <?php endforeach; ?>
            </select>

            <select name="budget">
                <option value="">Valor aproximado</option>
                <?php foreach ($budgets as $term): ?>
                    <option value="<?php echo esc_attr($term->slug); ?>"><?php echo esc_html($term->name); ?></option>
                <?php endforeach; ?>
            </select>

            <label class="baden-switch">
                <input type="checkbox" name="frente_mar" value="1">
                <span></span>
                Frente mar
            </label>

            <button type="submit" class="baden-search-submit">Buscar</button>
        </div>

    </form>

    <?php
    return ob_get_clean();
}
add_shortcode('baden_search', 'baden_search_shortcode');
add_action('wp_enqueue_scripts', function () {

    $css = "
    /* ==================================================
   CONTAINER GERAL
================================================== */
.baden-search-form {
    background: rgb(0 0 0 / 26%);
    padding: 30px;
    border-radius: 20px;
    max-width: 1290px;
    margin: auto;
}

/* ==================================================
   COMPRAR / ALUGAR (CENTRALIZADO)
================================================== */
.baden-search-tabs {
    display: flex;
    gap: 12px;
    justify-content: center;
    margin-bottom: 34px;
    border-bottom: 1px solid #ffffff;
}

.baden-tab {
    padding: 12px 34px;
    border-radius: 0px;
    border: none;
    cursor: pointer;
    font-weight: 700;
    background: none;
    color: #ffffff;
    opacity: .5;
    font-size: 24px;
    border-bottom: 5px solid;
}
button:hover.baden-tab{
    background-color: transparent;
    color: #fff;
    border-bottom: 5px solid #fff;
}

.baden-tab.active {
    opacity: 1;
	border-bottom: 5px solid #c7a15b;
	color:#c7a15b;
}

/* ==================================================
   CAMPOS (SELECTS + SWITCH)
================================================== */
.baden-search-fields {
    display: flex;
    gap: 14px;
    align-items: center;
    justify-content: center;
    flex-wrap: wrap;
}

/* ---------- SELECTS (DESKTOP BASE) ---------- */
.baden-search-fields select {
    width: 220px;
    min-width: 220px;
    max-width: 220px;
    padding: 14px;
    border-radius: 12px;
    border: none;
    font-size: 15px;
}

/* ==================================================
   SWITCH FRENTE MAR
================================================== */
.baden-switch {
    display: flex;
    align-items: center;
    gap: 12px;
    color: #fff;
    font-weight: 600;
    background-color: #c7a15b;
    padding: 12px 20px;
    border-radius: 15px;
}

/* Toggle visual */
.baden-switch input {
    appearance: none;
    width: 52px;
    height: 28px;
    background: #ffffff;
    border-radius: 20px;
    position: relative;
    cursor: pointer;
    transition: background .3s;
}

.baden-switch input::before {
    content: '';
    width: 22px;
    height: 22px;
    background: #c8a15c;
    border-radius: 50%;
    position: absolute;
    top: 3px;
    left: 3px;
    transition: transform .3s;
}

.baden-switch input:checked {
    
}

.baden-switch input:checked::before {
    transform: translateX(24px);
}

/* ==================================================
   BOTÃO BUSCAR (CENTRALIZADO)
================================================== */
.baden-search-submit {
    padding: 14px 30px;
    background: #c7a15b;
    color: #000;
    border-radius: 14px;
    border: none;
    font-weight: 800;
    cursor: pointer;

    width: 60%;
    max-width: 420px;
    margin: 24px auto 0;
    display: block;
}

/* ==================================================
   DESKTOP GRANDE (≥1280px)
================================================== */
@media (min-width: 1280px) {
    .baden-search-fields select {
        width: 220px !important;
    }

    .baden-search-submit {
        width: 60%;
    }
}

/* ==================================================
   NOTEBOOK (1024px – 1279px)
================================================== */
@media (max-width: 1279px) and (min-width: 1024px) {
    .baden-search-fields select {
        width: 200px;
        min-width: 200px;
    }

    .baden-search-submit {
        width: 70%;
    }
}

/* ==================================================
   TABLET (768px – 1023px)
================================================== */
@media (max-width: 1023px) and (min-width: 768px) {

    .baden-search-fields {
        justify-content: space-between;
    }

    .baden-search-fields select {
        width: 48%;
        max-width: none;
        min-width: 0;
    }

    .baden-search-submit {
        width: 80%;
    }
}

/* ==================================================
   MOBILE (≤767px)
================================================== */
@media (max-width: 767px) {

    .baden-search-fields {
        flex-direction: column;
        align-items: stretch;
    }

    .baden-search-fields select {
        width: 100%;
        max-width: none;
    }

    .baden-switch {
        justify-content: center;
    }

    .baden-search-submit {
        width: 100%;
    }
}

";

    wp_register_style('baden-search-style', false);
    wp_enqueue_style('baden-search-style');
    wp_add_inline_style('baden-search-style', $css);
});
add_action('wp_footer', function () {
?>
<script>
document.querySelectorAll('.baden-search-tabs .baden-tab').forEach(tab => {
    tab.addEventListener('click', function () {
        const wrap = tab.closest('.baden-search-form');
        wrap.querySelectorAll('.baden-tab').forEach(t => t.classList.remove('active'));
        tab.classList.add('active');
        wrap.querySelector('[name="negocio"]').value = tab.dataset.value;
    });
});
</script>
<?php
});


add_action('init', function () {
    ob_start(function ($html) {

        // remove NBSP real (U+00A0)
        $html = str_replace("\xC2\xA0", '', $html);

        // remove nós de texto entre tags
        $html = preg_replace('/>\s+</', '><', $html);

        return $html;
    });
}, 0);


add_action('wp_footer', function () {
?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const btnOpen  = document.querySelector('.btn-fale-consultor');
    const modal    = document.querySelector('.modal-whats');
    const btnClose = document.querySelector('.modal-close');

    if (!btnOpen || !modal) return;

    function openModal() {
        modal.style.display = 'block';
        modal.style.opacity = '1';
        modal.style.pointerEvents = 'auto';
        document.body.style.overflow = 'hidden';
    }

    function closeModal() {
        modal.style.display = 'none';
        modal.style.opacity = '0';
        modal.style.pointerEvents = 'none';
        document.body.style.overflow = '';
    }

    // Abrir modal
    btnOpen.addEventListener('click', function (e) {
        e.preventDefault();
        openModal();
    });

    // Fechar clicando no botão X
    if (btnClose) {
        btnClose.addEventListener('click', function (e) {
            e.preventDefault();
            closeModal();
        });
    }

    // Fechar clicando fora (overlay)
    modal.addEventListener('click', function (e) {
        if (e.target === modal) {
            closeModal();
        }
    });

    // Fechar com ESC
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') {
            closeModal();
        }
    });

});
</script>
<?php
});




