<?php
$project_id = get_the_ID();
?>
<div class="single-projects-header col-full">
    <?php echo
    get_the_term_list($project_id, 'project_location', '<div class="project-location"><i class="spaciaz-icon-marker"></i> ', ' ', '</div>');
    the_title('<h2 class="beta entry-title">', '</h2>');
    ?>
</div>

<div class="project-keys-container">

   <!-- Status -->
<div class="key-box">
    <div class="icon-circle">
        <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-layer-2"></i>
    </div>
    <div class="key-info">
        <span class="key-label">Status</span>
        <span class="key-value">
            <?php 
            $status_terms = wp_get_post_terms($project_id, 'project_status');
            echo !empty($status_terms) ? esc_html($status_terms[0]->name) : '—';
            ?>
        </span>
    </div>
</div>

<!-- Tipo -->
<div class="key-box">
    <div class="icon-circle">
        <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-buliding-2"></i>
    </div>
    <div class="key-info">
        <span class="key-label">Tipo do Imóvel</span>
        <span class="key-value">
            <?php 
            $type_terms = wp_get_post_terms($project_id, 'project_type');
            echo !empty($type_terms) ? esc_html($type_terms[0]->name) : '—';
            ?>
        </span>
    </div>
</div>

<!-- Área -->
<div class="key-box">
    <div class="icon-circle">
        <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-format-square"></i>
    </div>
    <div class="key-info">
        <span class="key-label">Área</span>
        <span class="key-value">
            <?php 
              $area_terms = wp_get_post_terms($project_id, 'project_area');
              echo !empty($area_terms) ? esc_html($area_terms[0]->name) : '—';
            ?>
        </span>
    </div>
</div>

<!-- Código -->
<div class="key-box">
    <div class="icon-circle">
        <i class="spaciaz-icon-marker"></i>
    </div>
    <div class="key-info">
        <span class="key-label">Código do Imóvel:</span>
        <span class="key-value">
            <?php echo esc_html(get_post_meta($project_id, 'project_code', true)); ?>
        </span>
    </div>
</div>

<!-- Valor -->
<div class="key-box">
    <div class="icon-circle">
        <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-dollar-circle"></i>
    </div>
    <div class="key-info">
        <span class="key-label">Valor</span>
        <span class="key-value">
            <?php
$valor_locacao = get_post_meta($project_id, 'valor_locacao', true);

// VENDA
$budget_terms = wp_get_post_terms($project_id, 'project_budget');
$valor_venda  = (!empty($budget_terms) && !is_wp_error($budget_terms))
    ? $budget_terms[0]->name
    : '';

if ($valor_venda) {

    echo esc_html($valor_venda);

} elseif ($valor_locacao) {

    echo 'R$ ' . number_format((float)$valor_locacao, 0, ',', '.'). ' / mês';

} else {

    echo '—';
}
?>
        </span>
    </div>
</div>

</div>





<div class="single-projects-header col-full">
<?php
$thumb = get_post_meta(get_the_ID(), 'jetimob_thumb', true);

if ($thumb) {
    echo '<div class="project-featured-image">';
    echo '<img src="' . esc_url($thumb) . '" alt="' . esc_attr(get_the_title()) . '">';
    echo '</div>';
}
?>
</div>


<div class="project-container">
    <div class="project-grid">

        <!-- COLUNA ESQUERDA -->
        <div class="project-main">
            <div class="project-description">
				<div class="key-box">
    <div class="key-info">
        <span class="key-value">
            <i class="spaciaz-icon spaciaz-icon-handshake"></i>
            <?php
            $neg = wp_get_post_terms($project_id, 'project_negociacao');
            echo (!empty($neg) && !is_wp_error($neg)) ? esc_html($neg[0]->name) : '—';
            ?>
        </span>
    </div>
</div>
				<h3>Sobre este imóvel</h3>
                <?php the_content(); ?>
            </div>
        </div>

        <!-- COLUNA DIREITA -->
        
<aside class="project-side">
<?php
// ---------- START: GET DATA (coloque isto ANTES do form) ----------
$codigo = get_post_meta(get_the_ID(), 'spaciaz_property_code', true);

// ---------- VALOR (VENDA OU LOCAÇÃO) ----------

// Venda
$budget_terms = wp_get_post_terms(get_the_ID(), 'project_budget');
$valor_venda  = (!empty($budget_terms) && !is_wp_error($budget_terms))
    ? $budget_terms[0]->name
    : '';

// Locação
$valor_locacao         = get_post_meta(get_the_ID(), 'valor_locacao', true);
$valor_locacao_visivel = get_post_meta(get_the_ID(), 'valor_locacao_visivel', true);

if ($valor_venda) {

    $valor = $valor_venda;

} elseif ($valor_locacao) {

    $valor = 'R$ ' . number_format((float)$valor_locacao, 0, ',', '.'). ' / mês';

} else {

    $valor = '';
}

$codigo = get_post_meta(get_the_ID(), 'project_code', true);
$mensagem_default = "Olá, vi o anúncio do imóvel código " . $codigo . " no site Baden Imobiliária LTDA e gostaria de mais informações. Aguardo seu contato.";

// Pega a UNIDADE BADEN (taxonomia)
$unidade_terms = wp_get_post_terms(get_the_ID(), 'unidades_baden');
$unidade_slug = (!empty($unidade_terms)) ? $unidade_terms[0]->slug : ''; // ex: baden-select

// NONCE + AJAX
$nonce = wp_create_nonce('jetimob_form_nonce');
$ajax_url = admin_url('admin-ajax.php');
// ---------- END: GET DATA ----------
?>

<div id="form-jetimob-wrapper" class="project-box">
    <h3>Contato</h3>

<?php
$negociacao = get_post_meta(get_the_ID(), '_negociacao_tipo', true);
$map = [
    'compra'         => 'Compra',
    'locacao'        => 'Locação',
    'compra_locacao' => 'Compra e Locação',
];

if (isset($map[$negociacao])) : ?>
    <div class="negociacao-wrapper">
        Disponível para <strong><?php echo $map[$negociacao]; ?></strong>
    </div>
<?php endif; ?>

<?php if ($valor): ?>
    <p style="font-size:18px; font-weight:600; margin-bottom:10px;">
        <?php echo esc_html($valor); ?>
    </p>
<?php endif; ?>

<form id="form-jetimob" autocomplete="on">

    <!-- CÓDIGO DO IMÓVEL -->
    <div class="formJet">
        <input type="hidden" name="codigo" value="<?php echo esc_attr($codigo); ?>">
    </div>

    <!-- VALOR DO IMÓVEL -->
    <div class="formJet">
        <input type="hidden" name="valor" value="<?php echo esc_attr($valor); ?>">
    </div>

    <!-- NONCE -->
    <div class="formJet">
        <input type="hidden" name="nonce" value="<?php echo esc_attr($nonce); ?>">
    </div>

    <!-- UNIDADE BADEN (NOVO – USADO PARA ROTEAR LEADS) -->
    <div class="formJet">
        <input type="hidden" name="unidade" value="<?php echo esc_attr($unidade_slug); ?>">
    </div>
	
	<div class="formJet">
        <input type="hidden" name="post_id" value="<?php echo get_the_ID(); ?>">
    </div>

    <div class="formJet">
        <label>Nome*</label>
        <input type="text" name="nome" required placeholder="Digite seu nome">
    </div>

    <div class="formJet">
        <label>Telefone*</label>
        <input type="text" name="telefone" required placeholder="(11) 99999-9999">
    </div>

    <div class="formJet">
        <label>E-mail*</label>
        <input type="email" name="email" required placeholder="Digite seu e-mail">
    </div>

    <div class="formJet">
        <label>Mensagem*</label>
        <textarea name="mensagem" required rows="4"><?php echo esc_textarea($mensagem_default); ?></textarea>
    </div>

    <button type="submit" id="btn-jetimob-send" style="
        background:#000;color:#fff;padding:12px;border-radius:24px;
        margin-top:12px;width:100%;border:none;font-size:16px;">
        Enviar
    </button>

</form>
<div id="form-jetimob-resposta" style="margin-top:15px;"></div>
</div>

</aside>


    </div>
</div>


<div class="single-project-content col-full bdImv">
	
	<div class="row">
	  <h3>Comodidades do imóvel</h3>
	</div>
	
<?php
$features = get_post_meta(get_the_ID(), '_spaciaz_project_features', true);

if(!empty($features)){
    echo '<div class="project-features-grid">';
    foreach($features as $f){
        echo '<div class="feature-item">';
        echo '<div class="feature-icon"><i class="'.esc_attr($f['icon']).'"></i></div>';
        echo '<div class="feature-title">'.esc_html($f['title']).'</div>';
        echo '</div>';
    }
    echo '</div>';
}
?>
</div>

<?php
$photos = get_post_meta(get_the_ID(), 'jetimob_images', true);
$plans = get_post_meta(get_the_ID(), 'jetimob_plans', true);
$video = get_post_meta(get_the_ID(), 'spaciaz_video_url', true);
$street = get_post_meta(get_the_ID(), 'spaciaz_street_view_url', true);
?>

<div class="media-tabs">
   <div class="single-project-content col-full">

    <div class="media-header-wrapper">

        <div class="media-title">
            <h3>Galeria do Imóvel</h3>
        </div>

        <div class="media-tabs-nav">
            <button data-tab="photos" class="active">
                <span class="e-n-tab-icon" style="padding-right: 8px;">
                <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-gallery"></i></span> Fotos
            </button>

            <button data-tab="plans">
                <span class="e-n-tab-icon" style="padding-right: 8px;">
                <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-expand-1"></i></span> Planta do Imóvel
            </button>

            <button data-tab="video">
                <span class="e-n-tab-icon" style="padding-right: 8px;">
                <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-video-play"></i></span> Video
            </button>

            <button data-tab="street">
                <span class="e-n-tab-icon" style="padding-right: 8px;">
                <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-picture-frame"></i></span> Localização
            </button>
        </div>

    </div>

</div> 
	   

    <!-- PHOTOS -->
    <div class="media-tab-content active" id="tab-photos">
        <div class="swiper photos-swiper">
            <div class="swiper-wrapper">
                <?php foreach($photos as $img): ?>
                    <div class="swiper-slide">
                        <img src="<?php echo esc_url($img); ?>" data-fancybox="photos">
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>
        </div>
    </div>

    <!-- PLANS -->
    <div class="media-tab-content" id="tab-plans">
        <div class="swiper plans-swiper">
            <div class="swiper-wrapper">
                <?php foreach($plans as $img): ?>
                    <div class="swiper-slide">
                        <img src="<?php echo esc_url($img); ?>" data-fancybox="plans">
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>
        </div>
    </div>

    <!-- VIDEO -->
    <div class="media-tab-content" id="tab-video">
        <?php if(!empty($video)) echo wp_oembed_get($video); ?>
    </div>

    <!-- STREET VIEW -->

	<div class="media-tab-content" id="tab-street">
    <?php if(!empty($street)): ?>
        <iframe
            src="<?php echo esc_url($street); ?>"
            width="100%"
            height="500"
            style="border:0;"
            allowfullscreen=""
            loading="lazy"
            referrerpolicy="no-referrer-when-downgrade">
        </iframe>
    <?php endif; ?>
</div>
	
</div>

<div class="single-project-content col-full">
<?php
$loc_subtitle = get_post_meta(get_the_ID(), 'spaciaz_location_subtitle', true);
$loc_title    = get_post_meta(get_the_ID(), 'spaciaz_location_title', true);
$loc_text     = get_post_meta(get_the_ID(), 'spaciaz_location_text', true);
$loc_map      = get_post_meta(get_the_ID(), 'spaciaz_location_map_iframe', true);
?>

<?php if($loc_title || $loc_map): ?>
<section class="location-section">
    <div class="location-container">
		
        <div class="location-info" style="border:0px; padding:0px;">
			<div class="anuncie">
			   <img src="https://imoveisbadenselect.com.br/wordpress/wp-content/uploads/2025/12/banner-anuncie.png">
		    </div>
			<div class="location-info">
            <?php if($loc_subtitle): ?>
                <span class="location-subtitle"><?php echo esc_html($loc_subtitle); ?></span>
            <?php endif; ?>

            <?php if($loc_title): ?>
                <h2 class="location-title"><?php echo esc_html($loc_title); ?></h2>
            <?php endif; ?>

            <?php if($loc_text): ?>
                <p class="location-text"><?php echo esc_html($loc_text); ?></p>
            <?php endif; ?>
			
			<a href="#" class="Btn">Fale com um especialista <i aria-hidden="true" class="spaciaz-icon- spaciaz-icon-arrow-long-right"></i></a>
			</div>
        </div>

        <div class="location-map">
            <div class="map-wrapper">
                <?php 
                if($loc_map) echo $loc_map; 
                ?>
            </div>
        </div>

    </div>
</section>
<?php endif; ?>
</div>


<?php
$prev = get_previous_post();
$next = get_next_post();
?>

<?php if ( $prev || $next ) : ?>
<div class="single-project-content col-full">
<div class="project-nav-wrapper">
    <div class="project-nav-container">

        <div class="project-nav-left">
            <?php if ( $prev ) : ?>
                <a href="<?php echo get_permalink($prev->ID); ?>" class="project-nav-link">
                    <span class="arrow">‹</span> Próximo Imóvel
                </a>
            <?php endif; ?>
        </div>

        <div class="project-nav-right">
            <?php if ( $next ) : ?>
                <a href="<?php echo get_permalink($next->ID); ?>" class="project-nav-link">
                    Imóvel Anterior<span class="arrow">›</span>
                </a>
            <?php endif; ?>
        </div>

    </div>
</div>
</div>
<?php endif; ?>

<style>
	.anuncie{
		width:100%;
		height:auto;
		margin-bottom:20px;
	}
	.anuncie img{
		width:100%;
		height:auto;
	}
/* Wrapper que engloba título à esquerda e tabs à direita */
.media-header-wrapper {
    display: flex;
    justify-content: space-between;
    align-items: center;

    border-top: 1px solid #ccc;

    margin-top: 40px;
    padding-top: 50px;
    margin-bottom: 50px;
    flex-wrap: wrap;
}

/* Título do bloco */
.media-title h3 {
    font-weight: 600;
    margin: 0;
}

/* Mantido exatamente igual ao original, apenas sem borda/margem duplicada */
.media-tabs-nav {
    display: flex;
    gap: 10px;
    overflow-x: auto;
}

/* Botões — IGUAL AO SEU CÓDIGO */
.media-tabs-nav button {
    background: none;
    cursor: pointer;
    font-size: 16px;
    transition: .2s;
    font-weight: 600;
    color: black;
    padding: 10px 20px;
    border: 1px solid #e0e0e0;
}

.media-tabs-nav button.active {
    opacity: 1;
    color: var(--n-tabs-title-color-active);
    background: var(--e-global-color-primary);
    border-style: solid;
    border-width: 1px;
    border-color: var(--e-global-color-primary);
    color: black;
    padding: 10px 20px;
}

.media-tabs-nav button:hover {
    background: var(--e-global-color-primary);
    border: 1px solid var(--e-global-color-primary);
}

/* Conteúdo das tabs */
.media-tab-content {
    display: none;
}

.media-tab-content.active {
    display: block;
}

/* Responsivo */
@media (max-width: 768px) {
    .media-header-wrapper {
        flex-direction: column;
        align-items: flex-start;
        gap: 20px;
    }

    .media-tabs-nav {
        width: 100%;
        justify-content: flex-start;
    }
}

/* Swiper */
.swiper { width:100%; padding-left:50px; padding-right:50px; box-sizing:border-box; }
.swiper-slide { display:flex; justify-content:center; align-items:center; transition:transform .3s, opacity .3s; }
/* DESKTOP - mantém exatamente como você enviou */
.swiper-slide img {
    width: 100%;
    max-width: 600px;
    border-radius: 8px;
    cursor: pointer;
    height: 500px;
    object-fit: cover;
}

/* TABLET */
@media (max-width: 1024px) {
    .swiper-slide img {
        width: 100%;     /* ocupa toda a largura disponível */
        height: 400px;   /* altura proporcional */
    }
}

/* MOBILE */
@media (max-width: 768px) {
    .swiper-slide img {
        width: 100%;     /* 100% do container */
        height: 260px;   /* altura suave para mobile */
    }
}

.swiper-slide-prev,
.swiper-slide-next { opacity:0.5; transform:scale(0.8); }
.swiper-slide-active { opacity:1; transform:scale(1); }

/* Swiper navigation arrows */
.swiper-button-prev,
.swiper-button-next { color:#000; }
	
/* Container grid com 4 blocos por linha */
.project-features-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr); /* 4 blocos por linha */
    gap: 20px;
    margin-top: 40px;
}

/* Responsivo: tablets */
@media (max-width: 1024px) {
    .project-features-grid {
        grid-template-columns: repeat(2, 1fr); /* 2 blocos por linha */
    }
}

/* Responsivo: mobile */
@media (max-width: 768px) {
    .project-features-grid {
        grid-template-columns: 1fr; /* 1 bloco por linha */
    }
}

/* Cada card de feature */
.feature-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: flex-start;
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    text-align: center;
    transition: transform 0.3s, box-shadow 0.3s;
	border: 1px solid #e0e0e0;
}

/* Efeito hover */
.feature-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
}

/* Ícone do feature */
.feature-icon {
    font-size: 40px;
    color: #c6a15b;
    margin-bottom: 12px;
}

/* Título do feature */
.feature-title {
    font-size: 16px;
    font-weight: 600;
    color: #111;
}

	.location-section {
    padding: 120px 0;
}

.location-container {
    max-width: 1380px;
    margin: 0 auto;
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 80px;
    align-items: start;
}
.location-info{
    border:1px solid #e0e0e0;
	padding:40px;
	border-radius:30px;
}

.location-subtitle {
    display: block;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 1.6px;
    color: #888;
    margin-bottom: 0px;
	font-weight:bold;
}

.location-title {
    font-size: 42px;
    line-height: 1.2;
    margin-bottom: 0px;
    color: #111;
}

.location-text {
    font-size: 17px;
    line-height: 1.7;
    color: #444;
    max-width: 520px;
}

.location-map .map-wrapper {
    width: 100%;
    height: 420px;
    border-radius: 12px;
    overflow: hidden;
}

.location-map iframe {
    width: 100%;
    height: 100%;
    border: none;
}

/* RESPONSIVO */
@media (max-width: 960px) {
    .location-container {
        grid-template-columns: 1fr;
        gap: 50px;
    }

    .location-map .map-wrapper {
        height: 340px;
    }
}
	
	
/**teste**/
	/* Container principal com largura máxima */
.project-container {
    max-width: 1320px;
    margin-left: auto;
    margin-right: auto;
    padding-left: calc(var(--gutter-width) / 2);
    padding-right: calc(var(--gutter-width) / 2);
}

/* GRID DESKTOP */
.project-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 60px;
    align-items: flex-start;
}

/* Coluna esquerda */
.project-main {
    width: 100%;
}

/* Coluna direita */
.project-side {
    width: 100%;
    position: sticky;
    top: 40px;
}

/* Box do formulário */
.project-box {
    padding: 25px;
    border: 1px solid #e5e5e5;
    border-radius: 12px;
    background: #fff;
}

/* ----------- RESPONSIVE ----------- */

/* Até 1024px — muda proporção e remove sticky */
@media (max-width: 1024px) {
    .project-grid {
        grid-template-columns: 1fr;
        gap: 40px;
    }

    .project-side {
        position: relative;
        top: 0;
    }
}

/* Até 768px (tablet vertical) — reduz espaçamentos */
@media (max-width: 768px) {
    .project-container {
        padding-left: 20px;
        padding-right: 20px;
    }

    .project-grid {
        gap: 30px;
    }

    .project-box {
        padding: 20px;
    }
}

/* Até 480px (mobile) — otimização máxima */
@media (max-width: 480px) {
    .project-grid {
        gap: 25px;
    }

    .project-box {
        padding: 18px;
    }
}
	
	.project-nav-wrapper {
    width: 100%;
    margin: 80px 0;
}

.project-nav-container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border: 1px solid #e5e5e5;
    border-radius: 40px;
    padding: 35px 60px;
    font-family: inherit;
}

.project-nav-left,
.project-nav-right {
    width: 50%;
    display: flex;
    justify-content: center;
}

.project-nav-left {
    border-right: 1px solid #e5e5e5;
}

.project-nav-link {
    font-size: 18px;
    font-weight: 600;
    color: #000;
    display: flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    text-transform: lowercase;
}

.project-nav-link .arrow {
    color: #c28b37; /* o dourado do site */
    font-size: 20px;
    line-height: 0;
}
	
/*bloco icones 5*/
.project-keys-container {
    display: flex;
    flex-wrap: wrap;
    gap: 32px;
    padding: 40px 0;
	margin-top:30px;
    max-width: 1320px;
    margin-left: auto;
    margin-right: auto;
    padding-left: calc(var(--gutter-width) / 2);
    padding-right: calc(var(--gutter-width) / 2);
	border-top: 1px solid #e0e0e0;
}

.key-box {
    display: flex;
    align-items: center;
    gap: 14px;
    flex: 1 1 calc(20% - 32px); /* 5 por linha no desktop */
    min-width: 200px;
}

.icon-circle {
    width: 52px;
    height: 52px;
    border-radius: 50%;
    border: 1px solid #e5e5e5;
    display: flex;
    align-items: center;
    justify-content: center;
}

.icon-circle i {
    font-size: 20px;
    color: #000;
}

.key-info {
    display: flex;
    flex-direction: column;
}

.key-label {
    font-size: 15px;
    color: #888;
}

.key-value {
    font-size: 17px;
    font-weight: 600;
    color: #000;
}

/* Responsividade */
@media (max-width: 1024px) {
    .key-box {
        flex: 1 1 calc(33.33% - 32px); /* 3 por linha */
    }
}

@media (max-width: 768px) {
    .key-box {
        flex: 1 1 calc(50% - 32px); /* 2 por linha */
    }
}

@media (max-width: 480px) {
    .key-box {
        flex: 1 1 100%; /* 1 por linha */
    }
    .icon-circle {
        width: 46px;
        height: 46px;
    }
    .key-value {
        font-size: 16px;
    }
}

.project-featured-image {
    width: 100%;
    height: 600px;
    overflow: hidden;
    border-radius: 30px;
    margin-bottom: 50px;
}

.project-featured-image img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* cobre todo o box sem distorcer */
    display: block;
}

/* Tablet */
@media (max-width: 1024px) {
    .project-featured-image {
        height: 400px; /* ajusta altura tablet */
    }
}

/* Mobile */
@media (max-width: 768px) {
    .project-featured-image {
        height: 300px; /* ajusta altura mobile */
    }
}
	
.bdImv{
	border-top: 1px solid #e0e0e0;
    padding-top: 40px;
    margin-top: 50px;	
}

.formJet{
	width:100%;
	height:auto;
	float:left;
	margin-bottom:5px;
}
.formJet input{
	width:100% !important;
	margin-top:5px;
}

.Btn{
	background: none;
    cursor: pointer;
    font-size: 16px;
    transition: .2s;
    font-weight: 600;
    color: black;
    padding: 10px 20px;
    border: 1px solid #e0e0e0;
	border-radius:80px;
}	
	
</style>

<!-- Swiper CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css" />

<!-- Fancybox CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css" />

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>

<!-- Fancybox JS -->
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.umd.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function(){

    // Tabs
    document.querySelectorAll('.media-tabs-nav button').forEach(btn=>{
        btn.addEventListener('click', ()=>{
            document.querySelector('.media-tabs-nav button.active')?.classList.remove('active');
            btn.classList.add('active');

            document.querySelector('.media-tab-content.active')?.classList.remove('active');
            document.getElementById('tab-'+btn.dataset.tab).classList.add('active');
        });
    });

    // Inicializa Swipers
    const initSwiper = (selector) => {
        const slidesCount = document.querySelectorAll(selector + ' .swiper-slide').length;

        const swiper = new Swiper(selector, {
            slidesPerView: slidesCount > 3 ? 3 : slidesCount,
            spaceBetween: 20,
            centeredSlides: true,
            loop: slidesCount > 1,
            loopedSlides: slidesCount,
            navigation: {
                nextEl: selector + ' .swiper-button-next',
                prevEl: selector + ' .swiper-button-prev'
            },
            breakpoints: {
                768: { slidesPerView: 1, centeredSlides: true },
                1024: { slidesPerView: slidesCount > 3 ? 3 : slidesCount, centeredSlides: true }
            },
            on: {
                init: function(){
                    this.update();   // Recalcula os slides
                    this.slideTo(Math.floor(slidesCount / 2), 0); // Força centralização da imagem do meio
                }
            }
        });

        return swiper;
    }

    initSwiper('.photos-swiper');
    initSwiper('.plans-swiper');

    // Lightbox
    Fancybox.bind('[data-fancybox]', { infinite: true });
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function() {

    const form = document.getElementById('form-jetimob');
    const resposta = document.getElementById('form-jetimob-resposta');
    const ajaxUrl = "<?php echo esc_js($ajax_url); ?>";

    form.addEventListener('submit', function(e){
        e.preventDefault();

        const btn = document.getElementById('btn-jetimob-send');
        btn.disabled = true;
        btn.style.opacity = '0.6';

        let dados = new FormData(form);

        fetch(ajaxUrl + '?action=enviar_jetimob', {
            method: 'POST',
            body: dados,
            credentials: 'same-origin'
        })
        .then(r => r.json())
        .then(r => {
            if (r.success) {
                resposta.innerHTML = '<div style="background:#e9ffee;border:1px solid #7cd68d;padding:12px;border-radius:8px;">✔ Sua mensagem foi enviada com sucesso!</div>';
                form.style.display = "none";

                setTimeout(function() {
                    resposta.innerHTML = "";
                    form.reset();
                    form.style.display = "block";
                    btn.disabled = false;
                    btn.style.opacity = '1';
                }, 4000);
            } else {
                resposta.innerHTML = '<div style="background:#ffe9e9;border:1px solid #ff8a8a;padding:12px;border-radius:8px;">❌ Erro: ' + (r.data || 'erro desconhecido') + '</div>';
                btn.disabled = false;
                btn.style.opacity = '1';
            }
        })
        .catch((err) => {
            resposta.innerHTML = '<div style="background:#ffe9e9;border:1px solid #ff8a8a;padding:12px;border-radius:8px;">❌ Erro inesperado ao enviar.</div>';
            btn.disabled = false;
            btn.style.opacity = '1';
            console.error(err);
        });
    });
});
</script>

