(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-video-tabs.default', ($scope) => {
            const $navItems = $scope.find('.video-tab-nav-item');
            const $contentItems = $scope.find('.video-tab-content');
            $navItems.on('click', function () {
                $navItems.removeClass('active');
                $contentItems.removeClass('active');
                $(this).addClass('active');
                const tabId = $(this).data('tab');
                $scope.find(`#${tabId}`).addClass('active');
            });

            function resizeVimeoVideos($scope) {
                $scope.find('.video-container').each(function () {
                    let $container = $(this);
                    let $iframe = $container.find('iframe');

                    let containerWidth = $container.outerWidth();
                    let containerHeight = $container.outerHeight();

                    let containerRatio = containerWidth / containerHeight;
                    let videoRatio = 16 / 9;

                    let newWidth, newHeight;

                    if (containerRatio < videoRatio) {
                        newHeight = containerHeight;
                        $iframe.css({
                            width: '300%',
                            height: newHeight + 'px'
                        });
                    } else {
                        newWidth = containerWidth * 3;
                        newHeight = containerWidth / videoRatio;
                        $iframe.css({
                            width: newWidth + 'px',
                            height: newHeight + 'px'
                        });
                    }
                });
            }

            function positionVideoContent($scope) {
                let $videoTabs = $scope.find('.video-tabs-element');
                const relativeId = $videoTabs.data('relative');
                if (!relativeId) {
                    return;
                }
                const $relativeElement = $(relativeId);
                const $videoContent = $scope.find('.video-tabs-content');
                if ($relativeElement.length) {
                    const relativeOffset = $relativeElement.offset();
                    const relativeWidth = $relativeElement.outerWidth();
                    const relativeHeight = $relativeElement.outerHeight();
                    $videoContent.css({
                        position: 'absolute',
                        top: relativeOffset.top - $scope.offset().top + 'px',
                        left: relativeOffset.left - $scope.offset().left + 'px',
                        width: relativeWidth + 'px',
                        height: relativeHeight + 'px'
                    });
                }
            }

            positionVideoContent($scope);
            resizeVimeoVideos($scope);
            $(window).on('resize', function () {
                resizeVimeoVideos($scope);
                positionVideoContent($scope);
            });
        });
    });
})(jQuery);