(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        const addHandler = ($element) => {
            elementorFrontend.elementsHandler.addHandler(spaciazSwiperBase, {
                $element,
            });

            if ($element.hasClass('elementor-service-style-6')) {
                let $title = $('.service-title-style-6');
                let $content = $('.service-content-style-6');
                $('.grid-item:first .service-title', $element).addClass('active');
                let firstID = $('.grid-item:first .service-title', $element).data('id');
                $content.removeClass('active')
                $('.service-content-' + firstID).addClass('active')

                $title.on('mouseenter', function (e) {
                    e.stopPropagation();
                    e.preventDefault();
                    let $id = $(this).data('id');
                    $title.removeClass('active');
                    $(this).addClass('active');
                    if ($content) {
                        $content.removeClass('active');
                        $('.service-content-' + $id).addClass('active')
                    }
                });

            }

            const $cards = $(".elementor-service-enable-sticky-yes .grid-item");

            if (!$cards.length) return;

            const startScale = 0.9;

            const checkVisibility = () => {
                const triggerTop = window.innerHeight * 0.85;

                $cards.each(function (index) {
                    const $card = $(this);
                    const $cardInner = $card.find(".service-inner");
                    if (!$cardInner.length) return;

                    const rect = $card[0].getBoundingClientRect();

                    if (rect.top > triggerTop) {
                        $cardInner.css({
                            transform: `scale(${startScale})`
                        });
                        return;
                    }

                    const distance = triggerTop - rect.top;
                    const maxDistance = window.innerHeight * 0.2;
                    let percent = distance / maxDistance;
                    percent = Math.min(1, Math.max(0, percent));

                    const scale = startScale + (1 - startScale) * percent;

                    if (percent >= 1) {
                        $cardInner.css({transform: "none"});
                    } else {
                        $cardInner.css({transform: `scale(${scale})`});
                    }
                });
            };

            $(window).on("scroll resize", checkVisibility);
            $(document).ready(checkVisibility);
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-services.default', addHandler);
    });
})(jQuery);