(function ($) {
    "use strict";

    $(window).on('elementor/frontend/init', () => {
        const addHandler = ($element) => {
            const $cardsContainer = $(".elementor-widget-spaciaz-projects-sticky .d-grid");
            const $cards = $(".elementor-widget-spaciaz-projects-sticky .grid-item");

            if (!$cardsContainer.length || $cards.length === 0) return;

            const firstCardHeight = $cards.first().outerHeight() / 2;

            $cardsContainer.css("--cards-count", $cards.length);
            $cardsContainer.css("--card-height", `${firstCardHeight}px`);

            let lastVisibleCard = null;

            const getStickyOffset = ($el) => {
                const computedStyle = window.getComputedStyle($el[0]);
                let topValue = computedStyle.top;

                if (topValue.includes("%")) {
                    const percentage = parseFloat(topValue) / 100;
                    return percentage * window.innerHeight;
                }

                return parseInt(topValue, 10) || 0;
            };

            const checkVisibility = () => {
                const screenMiddle = window.innerHeight * 0.5;

                $cards.each(function (index) {
                    if (index === $cards.length - 1) return;

                    const toScale = 1 - ($cards.length - 1) * 0.04;
                    const $nextCard = $cards.eq(index + 1);
                    const $cardInner = $(this).find(".project-style-4");
                    if (!$cardInner.length) return;

                    const stickyOffset = getStickyOffset($nextCard);

                    const rect = $nextCard[0].getBoundingClientRect();
                    const distanceFromMiddle = screenMiddle - rect.top;
                    const totalDistance = screenMiddle - stickyOffset;

                    let percentageY = Math.min(1, distanceFromMiddle / totalDistance);
                    percentageY = Math.max(0, percentageY);

                    const scaleValue = 1 - (1 - toScale) * percentageY;
                    const opacityValue = 1 - percentageY;

                    $cardInner.css({
                        transform: `scale(${scaleValue})`,
                        opacity: opacityValue.toFixed(2)
                    });
                });
            };
            $(window).on("scroll", checkVisibility);
            $(document).ready(checkVisibility);

        };
        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-projects-sticky.default', addHandler);
    });
})(jQuery);
