(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-projects-scroll.default', function ($scope) {
            const $window = $(window);
            HoverProject($scope);

            // Hover button wrap effect
            $('.project-post-thumbnail').on('mouseenter', function () {
                const $btnWrap = $(this).find('.project-button-wrap');
                $btnWrap.css('opacity', 1);
            });

            $('.project-post-thumbnail').on('mousemove', function (e) {
                const $btnWrap = $(this).find('.project-button-wrap');
                const offset = $(this).offset();
                const x = e.pageX - offset.left;
                const y = e.pageY - offset.top;

                const btnWidth = $btnWrap.outerWidth() / 2;
                const btnHeight = $btnWrap.outerHeight() / 2;

                const posX = x - btnWidth;
                const posY = y - btnHeight;

                $btnWrap.css({
                    transform: `translate3d(${posX}px, ${posY}px, 0px) scale3d(1, 1, 1) rotateX(0deg) rotateY(0deg) rotateZ(0deg) skew(0deg, 0deg)`,
                    'will-change': 'transform',
                    'transform-style': 'preserve-3d'
                });
            });

            $('.project-post-thumbnail').on('mouseleave', function () {
                const $btnWrap = $(this).find('.project-button-wrap');
                $btnWrap.css({
                    opacity: 0,
                    transform: 'translate3d(-0.01%, -0.01%, 0px) scale3d(1, 1, 1) rotateX(0deg) rotateY(0deg) rotateZ(0deg) skew(0deg, 0deg)',
                    'will-change': 'transform',
                    'transform-style': 'preserve-3d'
                });
            });
        });
    });

    function HoverProject($scope) {
        const $wrap = $scope.find('.elementor-project-scroll-wrapper');
        const $items = $wrap.find('.project-image-inner');
        const $info = $wrap.find('.project-content-inner');
        $items.eq(0).addClass('active');
        $info.eq(0).addClass('active');

        $items.each(function (index) {
            const $image = $(this).find('.project-post-thumbnail');
            $image.css({
                transform: `translateY(${index * 100}%)`,
            });
        });

        $info.each(function (index) {
            $(this).on('mouseenter', function () {
                $items.removeClass('active');
                $info.removeClass('active');
                $items.eq(index).addClass('active');
                $(this).addClass('active');

                $items.each(function (i) {
                    const offset = (i - index) * 100;
                    const $image = $(this).find('.project-post-thumbnail');
                    $image.css({
                        transform: `translateY(${offset}%)`,
                    });
                });
            });
        });
    }

})(jQuery);

