(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        const addHandler = ($element) => {
            let $wrapper = $element.find('.elementor-project-expand-wrapper');
            if ($wrapper.length) {
                let $itemChild = $wrapper.find('.project-inner');
                $itemChild.first().addClass('active');
                $itemChild.on('mouseenter', function () {
                    $itemChild.removeClass('active');
                    $(this).addClass('active');
                });
            }

        };

        $('.project-style-7').on('mouseenter', function () {
            const $btnWrap = $(this).find('.project-button-wrap');
            $btnWrap.css('opacity', 1);
        });

        $('.project-style-7').on('mousemove', function (e) {
            const $btnWrap = $(this).find('.project-button-wrap');
            const offset = $(this).offset();
            const x = e.pageX - offset.left;
            const y = e.pageY - offset.top;

            const btnWidth = $btnWrap.outerWidth() / 2;
            const btnHeight = $btnWrap.outerHeight() / 2;

            const posX = x - btnWidth;
            const posY = y - btnHeight;

            $btnWrap.css({
                transform: `translate3d(${posX}px, ${posY}px, 0px) scale3d(1, 1, 1) rotateX(0deg) rotateY(0deg) rotateZ(0deg) skew(0deg, 0deg)`,
                'will-change': 'transform',
                'transform-style': 'preserve-3d'
            });
        });

        $('.project-style-7').on('mouseleave', function () {
            const $btnWrap = $(this).find('.project-button-wrap');
            $btnWrap.css({
                opacity: 0,
                transform: 'translate3d(-0.01%, -0.01%, 0px) scale3d(1, 1, 1) rotateX(0deg) rotateY(0deg) rotateZ(0deg) skew(0deg, 0deg)',
                'will-change': 'transform',
                'transform-style': 'preserve-3d'
            });
        });

        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-projects-expand.default', addHandler);
    });
})(jQuery);