(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-iconboxs-tab.default', ($scope) => {

            const $detailsTabInfos = $scope.find('.details-tab-info');
            const $iconboxTabItems = $scope.find('.iconbox-tab-item');
            const $iconboxTabContent = $scope.find('.iconbox-tab-content');
            const $iconboxContents = $scope.find('.iconbox-content');

            function setMaxContentHeight() {
                if (window.innerWidth > 768) {
                    let maxHeight = 0;
                    $iconboxContents.each(function () {
                        const contentHeight = $(this).outerHeight();
                        if (contentHeight > maxHeight) {
                            maxHeight = contentHeight;
                        }
                    });
                    $iconboxTabContent.css({ height: maxHeight + "px" });
                } else {
                    $iconboxTabContent.css({ height: "auto" }); // Reset chiều cao khi nhỏ hơn 880px
                }
            }

            $detailsTabInfos.first().addClass('active');
            $iconboxTabItems.first().addClass('active');

            setMaxContentHeight();

            $detailsTabInfos.on('click', function (e) {
                e.preventDefault();
                const $currentTitle = $(this);
                const index = $detailsTabInfos.index($currentTitle);
                const $correspondingThumbnail = $iconboxTabItems.eq(index);

                if ($currentTitle.hasClass('active')) return;

                $detailsTabInfos.removeClass('active');
                $iconboxTabItems.removeClass('active');

                $currentTitle.addClass('active');
                $correspondingThumbnail.addClass('active');

                setMaxContentHeight();
            });

            $(window).on('resize', setMaxContentHeight);
        });
    });

})(jQuery);