(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        const addHandler = ($element) => {
            const $window = $(window);
            const $content = $element.find('.horizontal-scroll-inner');
            const $line = $element.find('.horizontal-scroll-line');
            if($line) {
                $line.css({
                    width: $content[0].scrollWidth
                })
            }
            const $stickyParent = $element.find('.horizontal-scroll-wrapper');
                updateContentTransform($window, $content, $stickyParent);
                $window.on('scroll', () => updateContentTransform($window, $content, $stickyParent));
                $window.on('resize', () => updateContentTransform($window, $content, $stickyParent));

        }
        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-horizontal-scroll.default', addHandler);
    });

    function updateContentTransform($window, $content, $stickyParent) {
        const stickyParentTop = $stickyParent.offset().top;
        const stickyParentHeight = $stickyParent.outerHeight();
        const stickyParentWidth = $stickyParent.width();
        const contentWidth = $content[0].scrollWidth;
        const contentHeight = $content.height();
        const contentTop = parseInt($content.css('top'), 10);
        const contentOffsetTop = $content.offset().top;
        const maxTranslateX = contentWidth - stickyParentWidth;
        const scrollTop = $window.scrollTop();
        const relativeSection = $content.data('relative');
        if (relativeSection) {
            const relativeSectionHeight = $(relativeSection).outerHeight();

            let bottom = (contentOffsetTop + contentHeight) - (stickyParentTop + stickyParentHeight);

            if ((contentOffsetTop >= stickyParentTop) && bottom <= -2) {
                $(relativeSection).css({
                    'position': 'sticky',
                    'top': -(relativeSectionHeight - contentTop),
                    'transform':'none'
                });

            } else if (bottom >= -2) {
                $(relativeSection).css({
                    'transition': 'none',
                    'transform':`translateY(-${(scrollTop + contentTop) - contentOffsetTop}px)`
                });

            } else {
                $(relativeSection).css({
                    'position': '',
                    'top': '',
                    'transform':'none'
                });

            }
        }
        const isRTL = $('body').hasClass('rtl');

        if ((contentOffsetTop >= stickyParentTop) && (contentOffsetTop + contentHeight) < (stickyParentTop + stickyParentHeight)) {
            const translateX = Math.min((scrollTop - stickyParentTop + contentTop) / (stickyParentHeight - contentHeight) * maxTranslateX, maxTranslateX);
            $content.css('transform', `translateX(${isRTL ? '' : '-'}${translateX}px)`);
        } else if ((contentOffsetTop + contentHeight) === (stickyParentTop + stickyParentHeight)) {
            $content.css('transform', `translateX(${isRTL ? '' : '-'}${maxTranslateX}px)`);
        }

        const $line_active = $stickyParent.find('.horizontal-scroll-line .line-active');
        if ($line_active && $line_active.length) {
            const scrollProgress = Math.min(Math.max((scrollTop - stickyParentTop + contentTop) / (stickyParentHeight - contentHeight), 0), 1);
            $line_active.css('width', `${scrollProgress * 100}%`);
        }
    }

})(jQuery);
