(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-careers-showcase.default', ($scope) => {
            var $slider = $scope.find('.swiper-careers-popup'),
                $sliderEffect = $scope.find('.swiper-careers-effect'),
                $careersEffect = $scope.find('.careers-effect'),
                $careersItem = $scope.find('.elementor-careersshowcase-item'),
                $careersPopup = $scope.find('.careers-popup'),
                careersID = $careersPopup.attr('id');

            var asyncSwiper = elementorFrontend.utils.swiper;
            new asyncSwiper($slider, {
                spaceBetween: 10,
                pagination: {
                    el: ".swiper-pagination",
                    clickable: true,
                },
            }).then((newSwiperInstance) => {
                $careersItem.on('click', function (e) {
                    e.preventDefault();
                    var $that = $(this);
                    var goto = $that.data('goto');
                    newSwiperInstance.slideTo(goto);
                });
            });

            if($sliderEffect.length){
                new asyncSwiper($sliderEffect, {
                    spaceBetween: 0,
                    direction:'vertical',
                    effect: 'cube',
                }).then((newSwiperInstance) => {
                    $careersItem.on('mouseenter', function (e) {
                        e.preventDefault();
                        var $that = $(this);
                        var goto = $that.data('goto');
                        newSwiperInstance.slideTo(goto);
                        let top = $(this).position().top;
                        let height = $(this).height();
                        $careersEffect.css({
                            top: top + (height/2)
                        })
                    });
                });
            }

            $(document).ready(function () {
                $careersItem.magnificPopup({
                    type: 'inline',
                    items: {
                        src: '#' + careersID
                    },
                    removalDelay: 500,
                    closeBtnInside: true,
                    showCloseBtn: false,
                    callbacks: {
                        beforeOpen: function () {
                            this.st.mainClass = 'mfp-zoom-in careers-popup-main mfp-fade';
                        }
                    },
                    midClick: true
                });
            });

            let $tabs = $scope.find('.elementor-careersshowcase-content-title .elementor-careersshowcase-item');
            let $contents = $scope.find('.careers-infor');
            $contents.filter('.elementor-active').show();
            var windowsize = $(window).width();
            function switchTab($currentTab) {
                let id = $currentTab.attr('aria-controls');

                $tabs.removeClass('elementor-active');
                $contents.removeClass('elementor-active');

                $currentTab.addClass('elementor-active');
                $contents.filter('#' + id).addClass('elementor-active');
            }

            if (windowsize > 767) {
                $tabs.hover(function (e) {
                    e.preventDefault();
                    if (!$(this).hasClass('elementor-active')) {
                        switchTab($(this));
                    }
                });
            } else {
                $tabs.on('click', function (e) {
                    e.preventDefault();
                    if (!$(this).hasClass('elementor-active')) {
                        switchTab($(this));
                    }
                });
            }
        });
    });
})(jQuery);