(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        const addHandler = ($element) => {
            $element.find('.movingButton').each(function() {
                $(this).on('mouseenter', function() {
                    let originalPosition = $(this).offset();
                    let button = $(this);

                    button.off('mousemove').on('mousemove', function(event) {
                        let deltaX = event.pageX - originalPosition.left - (button.outerWidth() / 2);
                        let deltaY = event.pageY - originalPosition.top - (button.outerHeight() / 2);

                        deltaX = Math.max(-20, Math.min(20, deltaX));
                        deltaY = Math.max(-20, Math.min(20, deltaY));

                        button.css({
                            'transform': `translate3d(${deltaX}px, ${deltaY}px, 0px)`
                        });
                    });
                });

                $(this).on('mouseleave', function() {
                    $(this).off('mousemove').css({
                        'transform': 'translate3d(0px, 0px, 0px)'
                    });
                });
            });
        };

        elementorFrontend.hooks.addAction('frontend/element_ready/spaciaz-button-mousemove.default', addHandler);
    });
})(jQuery);
