<?php
if (!defined('ABSPATH')) exit;

jw3_log("=== REPROCESS AREA START ===");

/**
 * Recupera todos os imóveis
 */
$posts = get_posts([
    'post_type'      => 'spaciaz_project',
    'posts_per_page' => -1,
    'fields'         => 'ids'
]);

$total   = count($posts);
$updated = 0;

foreach ($posts as $post_id){

    $raw = get_post_meta($post_id, '_jetimob_raw', true);

    if (!$raw || !is_array($raw)) {
        jw3_log("RAW NOT FOUND for post {$post_id}");
        continue;
    }

    // Código do imóvel
    $external = $raw['codigo'] ?? $post_id;

    /* ==========================================================
       REEXTRAÇÃO DE ÁREA
       ========================================================== */

    $area = null;

    if (!empty($raw['area_privativa']) && floatval($raw['area_privativa']) > 0){
        $area = $raw['area_privativa'];
    }
    elseif (!empty($raw['area_total']) && floatval($raw['area_total']) > 0){
        $area = $raw['area_total'];
    }
    elseif (!empty($raw['area_util']) && floatval($raw['area_util']) > 0){
        $area = $raw['area_util'];
    }
    elseif (!empty($raw['tipologia']) && is_array($raw['tipologia'])){
        $tip = implode(" ", $raw['tipologia']);
        if (preg_match('/(\d{2,4})\s?m/i', $tip, $m)) {
            $area = $m[1];
        }
    }
    elseif (!empty($raw['imovel_comodidades'])){
        if (preg_match('/(\d{2,4})\s?m/i', $raw['imovel_comodidades'], $m2)) {
            $area = $m2[1];
        }
    }

    if (!$area || floatval($area) <= 0){
        jw3_log("AREA NOT FOUND for {$external}");
        continue;
    }

    /* ==========================================================
       NORMALIZAÇÃO
       ========================================================== */

    $area_num = floatval(
        str_replace([',','m','²','m2','m²'], '', strtolower($area))
    );

    if ($area_num <= 0){
        jw3_log("INVALID AREA '{$area}' for {$external}");
        continue;
    }

    update_post_meta($post_id, 'project_area_raw', $area_num);

    $area_label = "{$area_num} m²";

    /* ==========================================================
       CRIA OU RECUPERA TERMOS NA TAXONOMY
       ========================================================== */

    $term = term_exists($area_label, 'project_area');

    if (!$term){
        $term = wp_insert_term($area_label, 'project_area');

        if (is_wp_error($term)){
            jw3_log("TERM ERROR '{$area_label}' -> ".$term->get_error_message());
            continue;
        }

        jw3_log("TERM CREATED '{$area_label}'");
    }

    // Recupera ID real do termo
    $term_id = is_array($term) ? $term['term_id'] : $term;

    /* ==========================================================
       ASSOCIA O TERMO AO IMÓVEL (POR ID – CORRETO)
       ========================================================== */

    $set = wp_set_post_terms(
        $post_id,
        [$term_id],
        'project_area',
        false
    );

    if (is_wp_error($set)){
        jw3_log("SET_TERM ERROR for {$external}: ".$set->get_error_message());
        continue;
    }

    $updated++;
    jw3_log("AREA UPDATED {$external} => {$area_label}");
}

jw3_log("=== REPROCESS AREA COMPLETE ({$updated} / {$total}) ===");

/**
 * Redireciona de volta ao painel
 */
wp_redirect(admin_url('options-general.php?page=jw3-imp'));
exit;
