<?php
if (!defined('ABSPATH')) exit;

/* ================================================================
   ADMIN MENU
================================================================ */
add_action('admin_menu', function(){
    add_options_page(
        'JW Jetimob Importer v3',
        'JW Jetimob Importer v3',
        'manage_options',
        'jw3-imp',
        'jw3_admin_page'
    );
});

/* ================================================================
   ADMIN PAGE
================================================================ */
function jw3_admin_page(){

    if (!current_user_can('manage_options')) wp_die('unauthorized');

    /* SAVE CONFIG */
    if (isset($_POST['jw3_save']) && check_admin_referer('jw3_save_action','jw3_save_nonce')){
        update_option('jw3_webservice_key', sanitize_text_field($_POST['jw3_webservice_key']));
        update_option('jw3_batch_size', intval($_POST['jw3_batch_size']));
        update_option('jw3_update_existing', isset($_POST['jw3_update_existing']) ? 'yes' : 'no');
        echo '<div class="updated"><p>Configurações salvas.</p></div>';
    }

    $key     = get_option('jw3_webservice_key','');
    $batch   = intval(get_option('jw3_batch_size',5));
    $pointer = intval(get_option('jw3_page_pointer',1));
    $logfile = wp_upload_dir()['basedir'] . '/jw-importer-logs/import.log';
    ?>

    <div class="wrap">
        <h1>JW Jetimob Importer v3</h1>

        <!-- CONFIGURAÇÕES -->
        <form method="post">
            <?php wp_nonce_field('jw3_save_action','jw3_save_nonce'); ?>

            <table class="form-table">
                <tr>
                    <th>Webservice Key</th>
                    <td><input type="text" name="jw3_webservice_key" value="<?php echo esc_attr($key); ?>" style="width:480px;" /></td>
                </tr>

                <tr>
                    <th>Batch Size</th>
                    <td><input type="number" name="jw3_batch_size" value="<?php echo esc_attr($batch); ?>" /></td>
                </tr>

                <tr>
                    <th>Atualizar existentes</th>
                    <td>
                        <label>
                            <input type="checkbox" name="jw3_update_existing" <?php checked(get_option('jw3_update_existing','yes')==='yes'); ?> />
                            Sim
                        </label>
                    </td>
                </tr>
            </table>

            <p class="submit">
                <button class="button button-primary" type="submit" name="jw3_save">Salvar</button>

                <?php if (!empty($key)): ?>
                    <a href="<?php echo esc_url(admin_url('admin-post.php?action=jw3_run_once')); ?>" class="button">Executar 1 ciclo agora</a>
                    <a href="<?php echo esc_url(admin_url('admin-post.php?action=jw3_reprocess_images')); ?>" class="button">Reprocessar imagens (20)</a>
                <?php endif; ?>
            </p>
        </form>

        <!-- FERRAMENTAS -->
        <h2>Ferramentas de Manutenção</h2>

        <p>
            <a class="button" href="<?php echo admin_url('admin-post.php?action=jw3_reprocess_area'); ?>">Reprocessar Área</a>

            <a class="button" href="<?php echo admin_url('admin-post.php?action=jw3_reprocess_tags'); ?>">Reprocessar Unidades Baden</a>

            <a class="button" href="<?php echo admin_url('admin-post.php?action=jw3_reprocess_taxonomies'); ?>">Reprocessar Status / Tipo / Localização</a>

            <a class="button" href="<?php echo admin_url('admin-post.php?action=jw3_reprocess_thumbs'); ?>">Reprocessar Thumbs</a>

            <!-- ✅ NOVO BOTÃO -->
            <a class="button" href="<?php echo admin_url('admin-post.php?action=jw3_reprocess_comodidades'); ?>">Reprocessar Comodidades</a>

            <a class="button button-primary" href="<?php echo admin_url('admin-post.php?action=jw3_rebuild_all'); ?>">Reprocessar TUDO (Full Rebuild)</a>

            <a class="button button-danger" style="background:#c00;color:#fff;border-color:#900;"
               href="<?php echo admin_url('admin-post.php?action=jw3_reset_all'); ?>"
               onclick="return confirm('Tem certeza que deseja apagar TODOS os imóveis e zerar tudo?');">
               RESET TOTAL – Apagar tudo
            </a>
        </p>

        <!-- STATUS -->
        <h2>Status</h2>
        <p>Ponteiro de página atual: <strong><?php echo esc_html($pointer); ?></strong></p>

        <!-- LOGS -->
        <h2>Logs (últimas linhas)</h2>
        <pre style="background:#f7f7f7;padding:12px;border-radius:6px;max-height:320px;overflow:auto;"><?php
            if (file_exists($logfile)){
                echo esc_html(implode("", array_slice(file($logfile), -150)));
            } else {
                echo 'Sem logs ainda.';
            }
        ?></pre>

    </div>

    <?php
}

/* ================================================================
   ACTION HANDLERS (admin-post.php)
================================================================ */

/* --- Reprocessar Área --- */
add_action('admin_post_jw3_reprocess_area', function(){
    if (!current_user_can('manage_options')) wp_die('unauthorized');
    include JW3_DIR . 'tools/reprocess-area.php';
});

/* --- Reprocessar Tags / Unidades Baden --- */
add_action('admin_post_jw3_reprocess_tags', function(){
    if (!current_user_can('manage_options')) wp_die('unauthorized');
    include JW3_DIR . 'tools/reprocess-tags.php';
});

/* --- Reprocessar Taxonomias (status/tipo/localização) --- */
add_action('admin_post_jw3_reprocess_taxonomies', function(){
    if (!current_user_can('manage_options')) wp_die('unauthorized');
    include JW3_DIR . 'tools/reprocess-taxonomies.php';
});

/* --- Reprocessar Thumbs --- */
add_action('admin_post_jw3_reprocess_thumbs', function(){
    if (!current_user_can('manage_options')) wp_die('unauthorized');
    include JW3_DIR . 'tools/reprocess-thumbs.php';
});

/* --- Reprocessar Comodidades --- */
add_action('admin_post_jw3_reprocess_comodidades', function(){
    if (!current_user_can('manage_options')) wp_die('unauthorized');
    include JW3_DIR . 'tools/reprocess-comodidades.php';
});

/* --- Rebuild ALL --- */
add_action('admin_post_jw3_rebuild_all', function(){
    if (!current_user_can('manage_options')) wp_die('unauthorized');
    include JW3_DIR . 'tools/rebuild-all.php';
});

/* --- Reset total --- */
add_action('admin_post_jw3_reset_all', function(){
    if (!current_user_can('manage_options')) wp_die('unauthorized');
    include JW3_DIR . 'tools/reset-all.php';
});
